/*
 * Decompiled with CFR 0.152.
 */
package bref;

import beagleutil.ChromIds;
import blbutil.FileUtil;
import blbutil.Utilities;
import bref.Bref3Reader;
import bref.BrefBlock;
import bref.BrefWriter;
import ints.IntArray;
import ints.IntList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.Samples;

public class AsIsBref3Writer
implements BrefWriter {
    public static final int END_OF_DATA = 0;
    public static final long END_OF_INDEX = -999999999999999L;
    public static final int MAGIC_NUMBER_V3 = 2055763188;
    public static final byte SEQ_CODED = 0;
    public static final byte ALLELE_CODED = 1;
    private final String WRITE_ERR = "Error writing file";
    private final String CONTIGUITY_ERR = "Error: chromosomes not contiguous";
    private final Set<String> BASES_SET = this.basesSet();
    private final String[][] SNV_PERMS = Bref3Reader.snvPerms();
    private final Comparator<String[]> ALLELES_COMP = AsIsBref3Writer.allelesComparator();
    public final int MAX_SAMPLES = 0x1FFFFFFF;
    private int lastChromIndex = -1;
    private IntArray hap2Seq = null;
    private long bytesWritten = 0L;
    private final File bref;
    private final Samples samples;
    private final int nHaps;
    private final List<RefGTRec> emBuffer;
    private final List<BrefBlock> index;
    private final DataOutputStream brefOut;
    private final ByteArrayOutputStream baos;
    private final DataOutputStream buffer;

    public AsIsBref3Writer(String string, Samples samples, File file) {
        if (string == null) {
            throw new NullPointerException(String.class.toString());
        }
        if (samples.size() > 0x1FFFFFFF) {
            throw new IllegalArgumentException(String.valueOf(samples.size()));
        }
        this.bref = file;
        this.samples = samples;
        this.nHaps = 2 * samples.size();
        this.emBuffer = new ArrayList<RefGTRec>(500);
        this.index = new ArrayList<BrefBlock>(500);
        this.brefOut = this.dataOutputStream(this.bref);
        this.baos = new ByteArrayOutputStream(100);
        this.buffer = new DataOutputStream(this.baos);
        try {
            this.brefOut.writeInt(2055763188);
            this.bytesWritten += 4L;
            this.writeString(string, this.brefOut);
            this.writeStringArray(samples.ids(), this.brefOut);
        }
        catch (IOException iOException) {
            Utilities.exit(iOException, "Error writing file");
        }
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public void write(RefGTRec refGTRec) {
        if (!refGTRec.samples().equals(this.samples)) {
            Utilities.exit("ERROR: inconsistent data");
        }
        if (this.startNewBlock(refGTRec)) {
            this.writeAndClearBuffer();
        }
        this.emBuffer.add(refGTRec);
    }

    private boolean startNewBlock(RefGTRec refGTRec) {
        boolean bl = false;
        int n = refGTRec.marker().chromIndex();
        if (n != this.lastChromIndex) {
            this.lastChromIndex = n;
            this.hap2Seq = null;
            bl = true;
        }
        if (!refGTRec.isAlleleCoded()) {
            if (this.hap2Seq == null) {
                this.hap2Seq = refGTRec.map(0);
            } else if (refGTRec.map(0) != this.hap2Seq) {
                this.hap2Seq = refGTRec.map(0);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void close() {
        try {
            this.writeAndClearBuffer();
            this.brefOut.writeInt(0);
            this.bytesWritten += 4L;
            long l = this.bytesWritten;
            this.writeIndex();
            this.brefOut.writeLong(l);
            this.bytesWritten += 8L;
            this.brefOut.close();
        }
        catch (IOException iOException) {
            Utilities.exit(iOException, "Error closing file");
        }
    }

    private void writeAndClearBuffer() {
        if (!this.emBuffer.isEmpty()) {
            try {
                Marker marker = this.emBuffer.get(0).marker();
                this.index.add(new BrefBlock(marker.chromIndex(), marker.pos(), this.bytesWritten));
                this.brefOut.writeInt(this.emBuffer.size());
                this.bytesWritten += 4L;
                this.writeString(marker.chrom(), this.brefOut);
                this.writeHapToSeq();
                int n = this.emBuffer.size();
                for (int i = 0; i < n; ++i) {
                    RefGTRec refGTRec = this.emBuffer.get(i);
                    if (refGTRec.isAlleleCoded()) {
                        this.writeAlleleCodedRec(refGTRec);
                        continue;
                    }
                    this.writeSeqCodedRec(refGTRec);
                }
                this.emBuffer.clear();
            }
            catch (IOException iOException) {
                Utilities.exit(iOException, "Error writing file");
            }
        }
    }

    private void writeHapToSeq() throws IOException {
        int n;
        RefGTRec refGTRec = null;
        int n2 = this.emBuffer.size();
        for (n = 0; n < n2 && refGTRec == null; ++n) {
            RefGTRec refGTRec2 = this.emBuffer.get(n);
            if (refGTRec2.isAlleleCoded()) continue;
            refGTRec = refGTRec2;
        }
        if (refGTRec == null) {
            this.brefOut.writeChar(0);
            for (n = 0; n < this.nHaps; ++n) {
                this.brefOut.writeChar(0);
            }
        } else {
            assert (refGTRec.nMaps() == 2);
            IntArray intArray = refGTRec.map(0);
            IntArray intArray2 = refGTRec.map(1);
            this.brefOut.writeChar(intArray2.size());
            int n3 = intArray.size();
            for (int i = 0; i < n3; ++i) {
                this.brefOut.writeChar(intArray.get(i));
            }
        }
        this.bytesWritten += (long)((this.nHaps + 1) * 2);
    }

    private void writeSeqCodedRec(RefGTRec refGTRec) throws IOException {
        if (refGTRec.marker().nAlleles() >= 256) {
            Utilities.exit("ERROR: more than 256 alleles: " + refGTRec.marker());
        }
        assert (refGTRec.nMaps() == 2);
        IntArray intArray = refGTRec.map(1);
        this.writeMarker(refGTRec.marker());
        this.brefOut.writeByte(0);
        int n = intArray.size();
        for (int i = 0; i < n; ++i) {
            this.brefOut.writeByte(intArray.get(i));
        }
        this.bytesWritten += (long)((intArray.size() + 1) * 1);
    }

    private void writeAlleleCodedRec(RefGTRec refGTRec) throws IOException {
        assert (refGTRec.isAlleleCoded());
        int n = refGTRec.marker().nAlleles();
        int n2 = refGTRec.majorAllele();
        this.writeMarker(refGTRec.marker());
        this.brefOut.writeByte(1);
        ++this.bytesWritten;
        for (int i = 0; i < n; ++i) {
            if (i == n2) {
                this.brefOut.writeInt(-1);
                this.bytesWritten += 4L;
                continue;
            }
            int n3 = refGTRec.alleleCount(i);
            this.brefOut.writeInt(refGTRec.alleleCount(i));
            for (int j = 0; j < n3; ++j) {
                this.brefOut.writeInt(refGTRec.hapIndex(i, j));
            }
            this.bytesWritten += (long)((n3 + 1) * 4);
        }
    }

    private void writeMarker(Marker marker) throws IOException {
        int n;
        int n2 = Math.min(marker.nIds(), 255);
        this.brefOut.writeInt(marker.pos());
        this.brefOut.writeByte(n2);
        this.bytesWritten += 5L;
        for (n = 0; n < n2; ++n) {
            this.writeString(marker.id(n), this.brefOut);
        }
        n = this.isSNV(marker) ? (int)this.snvCode(marker.alleles()) : -1;
        this.brefOut.writeByte(n);
        ++this.bytesWritten;
        if (n == -1) {
            this.writeStringArray(marker.alleles(), this.brefOut);
            this.brefOut.writeInt(marker.end());
            this.bytesWritten += 4L;
        }
    }

    private byte snvCode(String[] stringArray) {
        int n = Arrays.binarySearch(this.SNV_PERMS, stringArray, this.ALLELES_COMP);
        if (n < 0) {
            n = -n - 1;
        }
        int n2 = (n << 2) + (stringArray.length - 1);
        return (byte)n2;
    }

    private boolean isSNV(Marker marker) {
        int n = marker.nAlleles();
        for (int i = 0; i < n; ++i) {
            if (this.BASES_SET.contains(marker.allele(i))) continue;
            return false;
        }
        return true;
    }

    private static Comparator<String[]> allelesComparator() {
        return (stringArray, stringArray2) -> {
            int n = Math.min(((String[])stringArray).length, ((String[])stringArray2).length);
            for (int i = 0; i < n; ++i) {
                char c;
                char c2 = stringArray[i].charAt(0);
                if (c2 == (c = stringArray2[i].charAt(0))) continue;
                return c2 < c ? -1 : 1;
            }
            if (((String[])stringArray).length != ((String[])stringArray2).length) {
                return ((String[])stringArray).length < ((String[])stringArray2).length ? -1 : 1;
            }
            return 0;
        };
    }

    private Set<String> basesSet() {
        HashSet<String> hashSet = new HashSet<String>(4);
        hashSet.add("A");
        hashSet.add("C");
        hashSet.add("G");
        hashSet.add("T");
        return Collections.unmodifiableSet(hashSet);
    }

    private void writeIndex() throws IOException {
        this.writeIndexChroms();
        int n = -1;
        int n2 = this.index.size();
        for (int i = 0; i < n2; ++i) {
            BrefBlock brefBlock = this.index.get(i);
            long l = brefBlock.offset();
            int n3 = brefBlock.chromIndex();
            if (n3 != n) {
                n = n3;
                l = -l;
            }
            this.brefOut.writeLong(l);
            this.brefOut.writeInt(brefBlock.pos());
        }
        this.brefOut.writeLong(-999999999999999L);
        this.bytesWritten += (long)(12 * this.index.size() + 8);
    }

    private void writeIndexChroms() throws IOException {
        Object object;
        int n = -1;
        ArrayList<String> arrayList = new ArrayList<String>();
        IntList intList = new IntList();
        int n2 = this.index.size();
        for (int i = 0; i < n2; ++i) {
            object = this.index.get(i);
            int n3 = ((BrefBlock)object).chromIndex();
            if (n3 == n) continue;
            arrayList.add(ChromIds.instance().id(n3));
            intList.add(i);
            n = n3;
        }
        HashSet hashSet = new HashSet(arrayList);
        if (arrayList.size() != hashSet.size()) {
            Utilities.exit("Error: chromosomes not contiguous");
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        object = intList.toArray();
        this.writeStringArray(stringArray, this.brefOut);
        for (Object object2 : object) {
            this.brefOut.writeInt((int)object2);
        }
    }

    private DataOutputStream dataOutputStream(File file) {
        OutputStream outputStream = file == null ? new DataOutputStream(System.out) : FileUtil.bufferedOutputStream(file);
        return new DataOutputStream(outputStream);
    }

    private void writeStringArray(String[] stringArray, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(stringArray.length);
        this.bytesWritten += 4L;
        for (String string : stringArray) {
            this.writeString(string, dataOutputStream);
        }
    }

    private void writeString(String string, DataOutputStream dataOutputStream) throws IOException {
        this.baos.reset();
        this.buffer.writeUTF(string);
        this.bytesWritten += (long)this.baos.size();
        this.baos.writeTo(dataOutputStream);
    }
}

