/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Const;
import blbutil.Utilities;
import imp.ImpData;
import imp.ImpLS;
import imp.StateProbs;
import java.io.File;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReferenceArray;
import main.Par;
import main.RunStats;
import main.WindowWriter;
import phase.FixedPhaseData;
import phase.PhaseBaum1;
import phase.PhaseData;
import phase.PhaseLS;
import phase.Stage2Haps;
import vcf.BasicGT;
import vcf.GT;
import vcf.MarkerIndices;
import vcf.RefTargSlidingWindow;
import vcf.SlidingWindow;
import vcf.TargSlidingWindow;
import vcf.Window;
import vcf.XRefGT;

public class Main {
    private static final String VERSION = "(version 5.4)";
    public static final String PROGRAM = "beagle.05May22.33a.jar";
    public static final String COMMAND = "java -jar beagle.05May22.33a.jar";
    public static final String COPYRIGHT = "Copyright (C) 2014-2022 Brian L. Browning";
    public static final String SHORT_HELP = "beagle.05May22.33a.jar (version 5.4)" + Const.nl + "Copyright (C) 2014-2022 Brian L. Browning" + Const.nl + "Enter \"" + "java -jar beagle.05May22.33a.jar" + "\" to list command line argument";
    private final Par par;
    private final SlidingWindow slidingWind;
    private final RunStats runStats;
    private final WindowWriter windowWriter;
    private final Random rand;

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.US);
        if (stringArray.length == 0) {
            System.out.println("beagle.05May22.33a.jar (version 5.4)");
            System.out.println(COPYRIGHT);
            System.out.println(Par.usage());
            System.exit(0);
        }
        Par par = Main.parameters(stringArray);
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(par.nthreads()));
        RunStats runStats = new RunStats(par);
        runStats.printStartInfo();
        try (SlidingWindow slidingWindow = Main.slidingWindow(par);
             WindowWriter windowWriter = new WindowWriter(par, slidingWindow.targSamples());){
            Main main = new Main(par, slidingWindow, windowWriter, runStats);
            main.phaseAndImpute();
            runStats.printSummaryAndClose(slidingWindow.cumTargMarkers(), slidingWindow.cumMarkers());
        }
    }

    private Main(Par par, SlidingWindow slidingWindow, WindowWriter windowWriter, RunStats runStats) {
        this.par = par;
        this.slidingWind = slidingWindow;
        this.runStats = runStats;
        this.windowWriter = windowWriter;
        this.rand = new Random(par.seed());
    }

    private static SlidingWindow slidingWindow(Par par) {
        if (par.ref() == null) {
            return TargSlidingWindow.instance(par);
        }
        return RefTargSlidingWindow.instance(par);
    }

    private void phaseAndImpute() {
        Optional<Window> optional = this.slidingWind.nextWindow();
        this.printSampleSummary(optional);
        GT gT = null;
        while (optional.isPresent()) {
            Object object;
            Window window = optional.get();
            this.runStats.printWindowUpdate(window);
            FixedPhaseData fixedPhaseData = new FixedPhaseData(this.par, this.slidingWind.ped(), window, gT);
            PhaseData phaseData = new PhaseData(fixedPhaseData, this.rand.nextLong());
            if (fixedPhaseData.targGT().isPhased()) {
                object = XRefGT.fromPhasedGT(fixedPhaseData.targGT(), this.par.nthreads());
                gT = this.printWindow(window, (XRefGT)object);
            } else {
                this.phaseStage1Variants(phaseData);
                if (fixedPhaseData.stage1TargGT().nMarkers() == fixedPhaseData.targGT().nMarkers()) {
                    object = phaseData.estPhase().phasedHaps();
                    gT = this.printWindow(window, (XRefGT)object);
                } else {
                    object = this.phaseStage2Variants(phaseData);
                    gT = this.printWindow(window, (Stage2Haps)object);
                }
            }
            optional = this.slidingWind.nextWindow();
        }
        this.slidingWind.close();
    }

    private void printSampleSummary(Optional<Window> optional) {
        if (optional.isPresent()) {
            this.runStats.printSampleSummary(this.slidingWind.ped(), optional.get());
        }
    }

    private void phaseStage1Variants(PhaseData phaseData) {
        int n = this.par.burnin() + this.par.iterations();
        double d = 0.01;
        while (phaseData.it() < n) {
            long l = System.nanoTime();
            PhaseLS.runStage1(phaseData);
            this.runStats.printStage1Info(phaseData, System.nanoTime() - l);
            phaseData.incrementIt();
            double d2 = PhaseBaum1.getAndResetSwapRate();
            if (phaseData.it() >= this.par.burnin() || !(d2 <= d)) continue;
            phaseData.advanceToFirstPhasingIt();
        }
    }

    private Stage2Haps phaseStage2Variants(PhaseData phaseData) {
        long l = System.nanoTime();
        Stage2Haps stage2Haps = PhaseLS.runStage2(phaseData);
        this.runStats.printStage2Info(System.nanoTime() - l);
        return stage2Haps;
    }

    private XRefGT printWindow(Window window, XRefGT xRefGT) {
        boolean bl;
        boolean bl2 = bl = window.indices().nMarkers() != window.indices().nTargMarkers();
        if (!bl) {
            int n = window.indices().prevTargSplice();
            int n2 = window.indices().nextTargSplice();
            this.windowWriter.printPhased(xRefGT, n, n2);
            return this.phasedOverlap(window, xRefGT);
        }
        long l = System.nanoTime();
        ImpData impData = new ImpData(this.par, window, xRefGT, window.genMap());
        AtomicReferenceArray<StateProbs> atomicReferenceArray = ImpLS.stateProbs(impData);
        int n = window.indices().prevSplice();
        int n3 = window.indices().nextSplice();
        this.windowWriter.printImputed(impData, n, n3, atomicReferenceArray);
        this.runStats.imputationNanos(System.nanoTime() - l);
        this.runStats.printImputationUpdate();
        return this.phasedOverlap(window, xRefGT);
    }

    private GT printWindow(Window window, Stage2Haps stage2Haps) {
        boolean bl;
        boolean bl2 = bl = window.indices().nMarkers() != window.indices().nTargMarkers();
        if (!bl) {
            int n = window.indices().prevTargSplice();
            int n2 = window.indices().nextTargSplice();
            this.windowWriter.printPhased(stage2Haps, n, n2);
            return stage2Haps.toBasicGT(window.indices().targOverlapStart(), n2);
        }
        long l = System.nanoTime();
        BasicGT basicGT = stage2Haps.toBasicGT(0, window.targGT().nMarkers());
        XRefGT xRefGT = XRefGT.fromPhasedGT(basicGT, this.par.nthreads());
        ImpData impData = new ImpData(this.par, window, xRefGT, window.genMap());
        AtomicReferenceArray<StateProbs> atomicReferenceArray = ImpLS.stateProbs(impData);
        int n = window.indices().prevSplice();
        int n3 = window.indices().nextSplice();
        this.windowWriter.printImputed(impData, n, n3, atomicReferenceArray);
        this.runStats.imputationNanos(System.nanoTime() - l);
        this.runStats.printImputationUpdate();
        return this.phasedOverlap(window, xRefGT);
    }

    private XRefGT phasedOverlap(Window window, XRefGT xRefGT) {
        assert (xRefGT.isPhased());
        MarkerIndices markerIndices = window.indices();
        int n = markerIndices.targOverlapStart();
        int n2 = markerIndices.nextTargSplice();
        int n3 = n2 - n;
        return n3 == 0 ? null : xRefGT.restrict(n, n2);
    }

    private static Par parameters(String[] stringArray) {
        Par par = new Par(stringArray);
        Main.checkOutputPrefix(par);
        if ((double)par.window() < 1.1 * (double)par.overlap()) {
            String string = SHORT_HELP + Const.nl + Const.nl + "ERROR: The \"window\" parameter must be at least 1.1 times the \"overlap\" parameter" + Const.nl + "Exiting program.";
            Utilities.exit(string);
        }
        return par;
    }

    private static void checkOutputPrefix(Par par) {
        String string;
        Object object;
        File file = new File(par.out());
        if (file.isDirectory()) {
            object = "ERROR: \"out\" parameter cannot be a directory: \"" + par.out() + "\"";
            Utilities.exit(Par.usage() + (String)object);
        }
        if (((File)(object = new File(par.out() + ".vcf.gz"))).equals(par.ref())) {
            string = "ERROR: VCF output file equals input file: " + par.ref();
            Utilities.exit(Par.usage() + string);
        }
        if (((File)object).equals(par.gt())) {
            string = "ERROR: VCF output file equals input file: " + par.gt();
            Utilities.exit(Par.usage() + string);
        }
    }
}

