/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Const;
import blbutil.FileUtil;
import blbutil.Utilities;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Optional;
import main.Main;
import main.Par;
import main.Pedigree;
import phase.PhaseData;
import vcf.BasicGT;
import vcf.Marker;
import vcf.Markers;
import vcf.RefGT;
import vcf.Window;

public class RunStats {
    private final Par par;
    private final PrintWriter log;
    private final long startNanos = System.nanoTime();
    private long totalPhaseNanos = 0L;
    private long imputeNanos = 0L;
    private long totalImputeNanos = 0L;

    RunStats(Par par) {
        this.par = par;
        this.log = FileUtil.printWriter(new File(par.out() + ".log"));
    }

    public void printStartInfo() {
        String[] stringArray = this.par.args();
        if (this.par.noNThreads()) {
            int n = stringArray.length;
            stringArray = Arrays.copyOf(stringArray, stringArray.length + 1);
            stringArray[n] = "nthreads=" + this.par.nthreads();
        }
        Utilities.duoPrint(this.log, Main.SHORT_HELP + Const.nl);
        Utilities.duoPrintln(this.log, "Start time: " + Utilities.timeStamp());
        Utilities.duoPrint(this.log, Utilities.commandLine("beagle.05May22.33a.jar", stringArray));
        if (this.par.ped() != null) {
            String string = Const.nl + "WARNING: This version will not model duos or trios in the pedigree file";
            Utilities.duoPrintln(this.log, string);
        }
        if (this.par.map() == null) {
            String string = Const.nl + "No genetic map is specified: using 1 cM = 1 Mb";
            Utilities.duoPrintln(this.log, string);
        }
        this.log.flush();
    }

    public Par par() {
        return this.par;
    }

    public void printSampleSummary(Pedigree pedigree, Window window) {
        Optional<RefGT> optional = window.refGT();
        int n = optional.isPresent() ? optional.get().nSamples() : 0;
        Utilities.duoPrint(this.log, Const.nl);
        Utilities.duoPrint(this.log, String.format("Reference samples: %,20d%n", n));
        Utilities.duoPrint(this.log, String.format("Study     samples: %,20d%n", window.targGT().nSamples()));
        if (this.par.ped() != null) {
            Utilities.duoPrint(this.log, "  ");
            Utilities.duoPrint(this.log, String.valueOf(pedigree.nSingles()));
            Utilities.duoPrintln(this.log, " singles");
            Utilities.duoPrint(this.log, "  ");
            Utilities.duoPrint(this.log, String.valueOf(pedigree.nDuos()));
            Utilities.duoPrintln(this.log, " duos");
            Utilities.duoPrint(this.log, "  ");
            Utilities.duoPrint(this.log, String.valueOf(pedigree.nTrios()));
            Utilities.duoPrintln(this.log, " trios");
        }
        this.log.flush();
    }

    public void printWindowUpdate(Window window) {
        BasicGT basicGT = window.targGT();
        Optional<RefGT> optional = window.refGT();
        Markers markers = optional.isPresent() ? optional.get().markers() : basicGT.markers();
        Marker marker = markers.marker(0);
        Marker marker2 = markers.marker(markers.size() - 1);
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(Const.nl);
        stringBuilder.append("Window ");
        stringBuilder.append(window.windowIndex());
        stringBuilder.append(" [");
        String string = marker.chrom();
        if (!string.equals(".")) {
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        stringBuilder.append(marker.pos());
        stringBuilder.append('-');
        if (!string.equals(marker2.chrom())) {
            stringBuilder.append(marker2.chrom());
            stringBuilder.append(':');
        }
        stringBuilder.append(marker2.pos());
        stringBuilder.append(']');
        stringBuilder.append(Const.nl);
        if (optional.isPresent()) {
            stringBuilder.append(String.format("Reference markers: %,20d%n", markers.size()));
        }
        stringBuilder.append(String.format("Study     markers: %,20d%n", basicGT.nMarkers()));
        Utilities.duoPrint(this.log, stringBuilder.toString());
        this.log.flush();
    }

    public void printSummaryAndClose(int n, int n2) {
        long l = System.nanoTime() - this.startNanos;
        Utilities.duoPrint(this.log, Const.nl);
        Utilities.duoPrintln(this.log, "Cumulative Statistics:" + Const.nl);
        if (n != n2) {
            Utilities.duoPrint(this.log, String.format("Reference markers: %,20d%n", n2));
        }
        Utilities.duoPrint(this.log, String.format("Study     markers: %,20d%n%n", n));
        if (this.totalPhaseNanos > 1000L) {
            this.duoPrintNanos("Haplotype phasing time:        ", this.totalPhaseNanos);
        }
        if (this.totalImputeNanos > 0L) {
            this.duoPrintNanos("Imputation time:               ", this.totalImputeNanos);
        }
        this.duoPrintNanos("Total time:                    ", l);
        Utilities.duoPrintln(this.log, Const.nl + "End time: " + Utilities.timeStamp());
        Utilities.duoPrintln(this.log, "beagle.05May22.33a.jar finished");
        this.log.close();
    }

    public void phaseNanos(long l) {
        this.totalPhaseNanos += l;
    }

    public void imputationNanos(long l) {
        this.imputeNanos = l;
        this.totalImputeNanos += l;
    }

    public void printImputationUpdate() {
        Utilities.duoPrint(this.log, Const.nl);
        this.duoPrintNanos("Imputation time:               ", this.imputeNanos);
        this.log.flush();
    }

    public void println(String string) {
        Utilities.duoPrintln(this.log, string);
        this.log.flush();
    }

    public void printStage1Info(PhaseData phaseData, long l) {
        String string;
        if (phaseData.it() == this.par.burnin() && this.par.em()) {
            this.printEstimatedParameters(phaseData.ne(), phaseData.pMismatch());
        }
        this.phaseNanos(l);
        int n = phaseData.it();
        if (n < this.par.burnin()) {
            if (n == 0) {
                this.println("");
            }
            string = "Burnin  iteration " + (n + 1) + ":";
        } else {
            if ((n -= this.par.burnin()) == 0) {
                this.println("");
            }
            string = "Phasing iteration " + (n + 1) + ":";
        }
        this.duoPrintNanos(String.format("%1$-31s", string), l);
    }

    public void printStage2Info(long l) {
        this.phaseNanos(l);
        String string = "Low frequency phasing:";
        this.duoPrintNanos(String.format("%1$-31s", string), l);
    }

    public void printEstimatedParameters(long l, float f) {
        Utilities.duoPrintln(this.log, "");
        Utilities.duoPrint(this.log, String.format("%1$-31s", "Estimated ne:"));
        Utilities.duoPrintln(this.log, String.valueOf(l));
        Utilities.duoPrint(this.log, String.format("%1$-31s", "Estimated err:"));
        Utilities.duoPrintln(this.log, String.format("%1$7.1e", Float.valueOf(f)));
    }

    public void duoPrintNanos(String string, long l) {
        Utilities.duoPrint(this.log, string);
        Utilities.duoPrintln(this.log, Utilities.elapsedNanos(l));
    }
}

