/*
 * Decompiled with CFR 0.152.
 */
package phase;

import ints.IntArray;
import ints.SynchedIntList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import phase.FixedPhaseData;
import phase.PhaseData;
import vcf.BasicGT;
import vcf.GTRec;
import vcf.Markers;
import vcf.RefGTRec;
import vcf.Samples;
import vcf.Window;

public class Stage2Haps {
    private final FixedPhaseData fpd;
    private final GTRec[] stage1Recs;
    private final Markers markers;
    private final Samples targSamples;
    private final AtomicReferenceArray<SynchedIntList> rareCarriers;

    public Stage2Haps(PhaseData phaseData) {
        this.fpd = phaseData.fpd();
        this.stage1Recs = phaseData.estPhase().toGTRecs();
        this.markers = this.fpd.targGT().markers();
        this.targSamples = this.fpd.targGT().samples();
        this.rareCarriers = Stage2Haps.rareCarriers(this.fpd);
    }

    private static AtomicReferenceArray<SynchedIntList> rareCarriers(FixedPhaseData fixedPhaseData) {
        int n2 = fixedPhaseData.targGT().markers().sumAlleles();
        AtomicReferenceArray<SynchedIntList> atomicReferenceArray = new AtomicReferenceArray<SynchedIntList>(n2);
        IntStream.rangeClosed(0, fixedPhaseData.stage1To2().size()).parallel().forEach(n -> Stage2Haps.initList(fixedPhaseData, n, atomicReferenceArray));
        return atomicReferenceArray;
    }

    private static void initList(FixedPhaseData fixedPhaseData, int n, AtomicReferenceArray<SynchedIntList> atomicReferenceArray) {
        Markers markers = fixedPhaseData.targGT().markers();
        IntArray intArray = fixedPhaseData.stage1To2();
        int n2 = n == 0 ? 0 : intArray.get(n - 1) + 1;
        int n3 = n == intArray.size() ? markers.size() : intArray.get(n);
        for (int i = n2; i < n3; ++i) {
            int n4 = markers.marker(i).nAlleles();
            int n5 = markers.sumAlleles(i);
            for (int j = 0; j < n4; ++j) {
                IntArray intArray2 = fixedPhaseData.carriers(i, j);
                if (intArray2 == Window.HIGH_FREQ_ARRAY) continue;
                atomicReferenceArray.set(n5 + j, new SynchedIntList(intArray2.size()));
            }
        }
    }

    public FixedPhaseData fpd() {
        return this.fpd;
    }

    public void setPhasedGT(int n, int n2, int n3, int n4) {
        SynchedIntList synchedIntList;
        int n5 = this.markers.sumAlleles(n);
        SynchedIntList synchedIntList2 = this.rareCarriers.get(n5 + n3);
        if (synchedIntList2 != null) {
            synchedIntList2.add(n2 << 1);
        }
        if ((synchedIntList = this.rareCarriers.get(n5 + n4)) != null) {
            synchedIntList.add(n2 << 1 | 1);
        }
    }

    public BasicGT toBasicGT(int n, int n2) {
        GTRec[] gTRecArray = this.toGTRecs(n, n2);
        if (n == 0 && n2 == this.markers.size()) {
            return new BasicGT(this.markers, this.targSamples, gTRecArray);
        }
        return new BasicGT(this.targSamples, gTRecArray);
    }

    public GTRec[] toGTRecs(int n2, int n3) {
        return (GTRec[])IntStream.range(n2, n3).parallel().boxed().map(n -> this.gtRec((int)n)).toArray(GTRec[]::new);
    }

    private GTRec gtRec(int n) {
        int n2 = this.fpd.prevStage1Marker(n);
        int n3 = this.fpd.stage1To2().get(n2);
        return n == n3 ? this.stage1Recs[n2] : this.stage2Rec(n);
    }

    private RefGTRec stage2Rec(int n) {
        int n2 = this.markers.sumAlleles(n);
        int n3 = this.markers.sumAlleles(n + 1);
        int[][] nArrayArray = new int[n3 - n2][];
        int n4 = -1;
        for (int i = 0; i < nArrayArray.length; ++i) {
            SynchedIntList synchedIntList = this.rareCarriers.get(n2 + i);
            if (synchedIntList != null) {
                nArrayArray[i] = synchedIntList.toArray();
                Arrays.sort(nArrayArray[i]);
                continue;
            }
            n4 = i;
        }
        if (n4 == -1) {
            this.setMajorAlleleToNull(nArrayArray);
        }
        return RefGTRec.hapCodedInstance(this.markers.marker(n), this.targSamples, nArrayArray);
    }

    private int setMajorAlleleToNull(int[][] nArray) {
        int n = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i].length <= nArray[n].length) continue;
            n = i;
        }
        nArray[n] = null;
        return n;
    }
}

