/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import vcf.Marker;
import vcf.Markers;
import vcf.Samples;

public interface GT {
    public boolean isReversed();

    public int nMarkers();

    public Marker marker(int var1);

    public Markers markers();

    public int nHaps();

    public int nSamples();

    public Samples samples();

    public boolean isPhased();

    public int allele1(int var1, int var2);

    public int allele2(int var1, int var2);

    public int allele(int var1, int var2);

    public GT restrict(Markers var1, int[] var2);

    public GT restrict(int var1, int var2);

    public static float gl(GT gT, int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = gT.marker(n).nAlleles();
        if (n3 < 0 || n3 >= n5) {
            String string = "invalid alleles: (" + n3 + "): " + n;
            throw new IllegalArgumentException(string);
        }
        if (n4 < 0 || n4 >= n5) {
            String string = "invalid alleles: (" + n4 + "): " + n;
            throw new IllegalArgumentException(string);
        }
        int n6 = gT.allele1(n, n2);
        int n7 = gT.allele2(n, n2);
        boolean bl2 = bl = !(n6 != -1 && n6 != n3 || n7 != -1 && n7 != n4);
        if (!bl) {
            bl = !(n6 != -1 && n6 != n4 || n7 != -1 && n7 != n3);
        }
        return bl ? 1.0f : 0.0f;
    }
}

