/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import ints.IntArray;
import java.util.Arrays;
import java.util.stream.IntStream;
import vcf.GTRec;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.Samples;
import vcf.VcfRecGTParser;

public final class LowMafRefGTRec
implements RefGTRec {
    private final Marker marker;
    private final Samples samples;
    private final int nHaps;
    private final int majorAllele;
    private final int[][] hapIndices;

    public LowMafRefGTRec(RefGTRec refGTRec) {
        this.hapIndices = refGTRec.hapIndices();
        int n = 0;
        while (this.hapIndices[n] != null) {
            ++n;
        }
        this.marker = refGTRec.marker();
        this.samples = refGTRec.samples();
        this.nHaps = refGTRec.size();
        this.majorAllele = n;
    }

    public LowMafRefGTRec(VcfRecGTParser vcfRecGTParser) {
        this.marker = vcfRecGTParser.marker();
        this.samples = vcfRecGTParser.samples();
        this.nHaps = 2 * vcfRecGTParser.nSamples();
        this.hapIndices = vcfRecGTParser.nonMajRefIndices();
        int n = -1;
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (this.hapIndices[i] != null) continue;
            n = i;
            break;
        }
        this.majorAllele = n;
    }

    public LowMafRefGTRec(Marker marker, Samples samples, int[][] nArray) {
        this.marker = marker;
        this.samples = samples;
        this.nHaps = 2 * samples.size();
        this.majorAllele = LowMafRefGTRec.checkIndicesAndReturnNullIndex(nArray, this.nHaps);
        this.hapIndices = LowMafRefGTRec.deepCopy(nArray);
    }

    static int checkIndicesAndReturnNullIndex(int[][] nArray, int n) {
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) {
                if (n2 == -1) {
                    n2 = i;
                    continue;
                }
                LowMafRefGTRec.throwArrayError();
                continue;
            }
            LowMafRefGTRec.checkSorted(nArray[i], n);
        }
        if (n2 == -1) {
            LowMafRefGTRec.throwArrayError();
        }
        return n2;
    }

    private static void throwArrayError() {
        throw new IllegalArgumentException("invalid array");
    }

    private static void checkSorted(int[] nArray, int n) {
        if (nArray.length > 0 && (nArray[0] < 0 || nArray[nArray.length - 1] >= n)) {
            LowMafRefGTRec.throwArrayError();
        }
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i - 1] < nArray[i]) continue;
            LowMafRefGTRec.throwArrayError();
        }
    }

    static int[][] deepCopy(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) continue;
            nArrayArray[i] = (int[])nArray[i].clone();
        }
        return nArray;
    }

    @Override
    public int[][] hapIndices() {
        return LowMafRefGTRec.deepCopy(this.hapIndices);
    }

    @Override
    public boolean isPhased(int n) {
        if (n < 0 || n >= this.samples().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int size() {
        return this.nHaps;
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public int allele1(int n) {
        return this.get(n << 1);
    }

    @Override
    public int allele2(int n) {
        return this.get(n << 1 | 1);
    }

    @Override
    public int get(int n) {
        if (n < 0 || n >= this.nHaps) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (i == this.majorAllele || Arrays.binarySearch(this.hapIndices[i], n) < 0) continue;
            return i;
        }
        return this.majorAllele;
    }

    @Override
    public int[] alleles() {
        int[] nArray = IntStream.range(0, this.nHaps).map(n -> this.majorAllele).toArray();
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (i == this.majorAllele) continue;
            for (int n2 : this.hapIndices[i]) {
                nArray[n2] = i;
            }
        }
        return nArray;
    }

    @Override
    public boolean isAlleleCoded() {
        return true;
    }

    @Override
    public int majorAllele() {
        return this.majorAllele;
    }

    @Override
    public int[] alleleCounts() {
        int[] nArray = new int[this.marker.nAlleles()];
        nArray[this.majorAllele] = this.nHaps;
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            if (i == this.majorAllele) continue;
            nArray[i] = n = this.hapIndices[i].length;
            int n2 = this.majorAllele;
            nArray[n2] = nArray[n2] - n;
        }
        return nArray;
    }

    @Override
    public int alleleCount(int n) {
        if (this.hapIndices[n] == null) {
            throw new IllegalArgumentException("major allele");
        }
        return this.hapIndices[n].length;
    }

    @Override
    public int hapIndex(int n, int n2) {
        if (this.hapIndices[n] == null) {
            throw new IllegalArgumentException("major allele");
        }
        return this.hapIndices[n][n2];
    }

    @Override
    public boolean isCarrier(int n, int n2) {
        return this.get(n2) == n;
    }

    public String toString() {
        return GTRec.toVcfRec(this);
    }

    @Override
    public int nMaps() {
        return 1;
    }

    @Override
    public IntArray[] maps() {
        return new IntArray[]{this.toIntArray()};
    }

    @Override
    public IntArray map(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.toIntArray();
    }

    private IntArray toIntArray() {
        int[] nArray = IntStream.range(0, this.nHaps).map(n -> this.majorAllele).toArray();
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (this.hapIndices[i] == null) continue;
            for (int n2 : this.hapIndices[i]) {
                nArray[n2] = i;
            }
        }
        return IntArray.packedCreate(nArray, this.hapIndices.length);
    }
}

