/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import ints.IntList;
import java.util.Arrays;
import java.util.stream.IntStream;

public class MarkerIndices {
    private final int prevSplice;
    private final int overlapEnd;
    private final int overlapStart;
    private final int nextSplice;
    private final int[] targMarkerToMarker;
    private final int[] markerToTargMarker;
    private final int targPrevSplice;
    private final int targOverlapEnd;
    private final int targOverlapStart;
    private final int targNextSplice;

    public MarkerIndices(boolean[] blArray, int n, int n2) {
        if (n < 0 || n > blArray.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 < 0 || n2 > blArray.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        this.prevSplice = n >> 1;
        this.overlapEnd = n;
        this.overlapStart = n2;
        this.nextSplice = blArray.length + n2 >>> 1;
        this.targMarkerToMarker = MarkerIndices.targMarkerToMarker(blArray);
        this.markerToTargMarker = this.markerToTargMarker(this.targMarkerToMarker, blArray.length);
        this.targPrevSplice = MarkerIndices.targIndex(this.targMarkerToMarker, this.prevSplice);
        this.targOverlapEnd = MarkerIndices.targIndex(this.targMarkerToMarker, n);
        this.targOverlapStart = MarkerIndices.targIndex(this.targMarkerToMarker, n2);
        this.targNextSplice = MarkerIndices.targIndex(this.targMarkerToMarker, this.nextSplice);
    }

    public MarkerIndices(int n, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException(String.valueOf(n3));
        }
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        this.prevSplice = n >> 1;
        this.overlapEnd = n;
        this.overlapStart = n2;
        this.nextSplice = n3 + n2 >>> 1;
        int[] nArray = IntStream.range(0, n3).parallel().toArray();
        this.targMarkerToMarker = nArray;
        this.markerToTargMarker = nArray;
        this.targPrevSplice = this.prevSplice;
        this.targOverlapEnd = n;
        this.targOverlapStart = n2;
        this.targNextSplice = this.nextSplice;
    }

    private static int targIndex(int[] nArray, int n) {
        int n2 = Arrays.binarySearch(nArray, n);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        return n2;
    }

    private static int[] targMarkerToMarker(boolean[] blArray) {
        IntList intList = new IntList(1 + blArray.length >> 6);
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            intList.add(i);
        }
        return intList.toArray();
    }

    private int[] markerToTargMarker(int[] nArray, int n2) {
        int[] nArray2 = IntStream.range(0, n2).parallel().map(n -> -1).toArray();
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray[i]] = i;
        }
        return nArray2;
    }

    public int nMarkers() {
        return this.markerToTargMarker.length;
    }

    public int nTargMarkers() {
        return this.targMarkerToMarker.length;
    }

    public int prevSplice() {
        return this.prevSplice;
    }

    public int overlapEnd() {
        return this.overlapEnd;
    }

    public int overlapStart() {
        return this.overlapStart;
    }

    public int prevTargSplice() {
        return this.targPrevSplice;
    }

    public int nextSplice() {
        return this.nextSplice;
    }

    public int targOverlapEnd() {
        return this.targOverlapEnd;
    }

    public int targOverlapStart() {
        return this.targOverlapStart;
    }

    public int nextTargSplice() {
        return this.targNextSplice;
    }

    public int targMarkerToMarker(int n) {
        return this.targMarkerToMarker[n];
    }

    public int[] targMarkerToMarker() {
        return (int[])this.targMarkerToMarker.clone();
    }

    public int markerToTargMarker(int n) {
        return this.markerToTargMarker[n];
    }

    public int[] markerToTargMarker() {
        return (int[])this.markerToTargMarker.clone();
    }
}

