/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import vcf.GT;
import vcf.GTRec;
import vcf.Marker;
import vcf.Markers;
import vcf.RefGTRec;
import vcf.Samples;

public class RefGT
implements GT {
    private final Markers markers;
    private final Samples samples;
    private final RefGTRec[] recs;

    public RefGT(Markers markers, Samples samples, RefGTRec[] refGTRecArray) {
        RefGT.checkData(markers, samples, refGTRecArray);
        this.markers = markers;
        this.samples = samples;
        this.recs = (RefGTRec[])refGTRecArray.clone();
    }

    public RefGT(RefGTRec[] refGTRecArray) {
        this.samples = RefGT.checkData(refGTRecArray);
        Marker[] markerArray = (Marker[])((Stream)Arrays.stream(refGTRecArray).parallel()).map(refGTRec -> refGTRec.marker()).toArray(Marker[]::new);
        this.markers = Markers.create(markerArray);
        this.recs = (RefGTRec[])refGTRecArray.clone();
    }

    private static Samples checkData(GTRec[] gTRecArray) {
        if (gTRecArray.length == 0) {
            String string = "Missing data in VCF file";
            throw new IllegalArgumentException(string);
        }
        Samples samples = gTRecArray[0].samples();
        for (int i = 0; i < gTRecArray.length; ++i) {
            if (!gTRecArray[i].samples().equals(samples)) {
                String string = "sample inconsistency at index " + i;
                throw new IllegalArgumentException(string);
            }
            if (gTRecArray[i].isPhased()) continue;
            String string = "non-reference data at marker index " + i;
            throw new IllegalArgumentException(string);
        }
        return samples;
    }

    private static void checkData(Markers markers, Samples samples, GTRec[] gTRecArray) {
        if (markers.size() != gTRecArray.length) {
            String string = "markers.nMarkers()=" + markers.size() + " refVcfRecs.length=" + gTRecArray.length;
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < gTRecArray.length; ++i) {
            if (!gTRecArray[i].samples().equals(samples)) {
                String string = "sample inconsistency at index " + i;
                throw new IllegalArgumentException(string);
            }
            if (!gTRecArray[i].marker().equals(markers.marker(i))) {
                String string = "marker inconsistency at index " + i;
                throw new IllegalArgumentException(string);
            }
            if (gTRecArray[i].isPhased()) continue;
            String string = "non-reference data at marker index " + i;
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public int nMarkers() {
        return this.markers.size();
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.size();
    }

    @Override
    public int nSamples() {
        return this.samples.size();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public int allele1(int n, int n2) {
        return this.recs[n].allele1(n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.recs[n].allele2(n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.recs[n].get(n2);
    }

    public static RefGT restrict(RefGT refGT, int[] nArray) {
        RefGTRec[] refGTRecArray = new RefGTRec[nArray.length];
        for (int i = 0; i < refGTRecArray.length; ++i) {
            if (i > 0 && nArray[i] <= nArray[i - 1]) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            refGTRecArray[i] = refGT.recs[nArray[i]];
        }
        return new RefGT(refGT.markers, refGT.samples, refGTRecArray);
    }

    @Override
    public RefGT restrict(Markers markers, int[] nArray) {
        RefGTRec[] refGTRecArray = new RefGTRec[nArray.length];
        for (int i = 0; i < refGTRecArray.length; ++i) {
            if (i > 0 && nArray[i] <= nArray[i - 1]) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            refGTRecArray[i] = this.recs[nArray[i]];
        }
        return new RefGT(markers, this.samples, refGTRecArray);
    }

    @Override
    public RefGT restrict(int n2, int n3) {
        Markers markers = this.markers.restrict(n2, n3);
        RefGTRec[] refGTRecArray = (RefGTRec[])IntStream.range(n2, n3).mapToObj(n -> this.recs[n]).toArray(RefGTRec[]::new);
        return new RefGT(markers, this.samples, refGTRecArray);
    }

    public RefGTRec get(int n) {
        return this.recs[n];
    }
}

