/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.util.stream.IntStream;
import vcf.GT;
import vcf.Marker;
import vcf.Markers;
import vcf.Samples;

public class RestrictedGT
implements GT {
    private final GT gt;
    private final Markers restrictedMarkers;
    private final int[] inclusionMap;

    public RestrictedGT(GT gT, Markers markers, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0 && nArray[i] <= nArray[i - 1]) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            if (gT.marker(nArray[i]).equals(markers.marker(i))) continue;
            throw new IllegalArgumentException(markers.marker(i).toString());
        }
        this.gt = gT;
        this.restrictedMarkers = markers;
        this.inclusionMap = (int[])nArray.clone();
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public int nMarkers() {
        return this.restrictedMarkers.size();
    }

    @Override
    public Marker marker(int n) {
        return this.restrictedMarkers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.restrictedMarkers;
    }

    @Override
    public int nHaps() {
        return this.gt.nHaps();
    }

    @Override
    public int nSamples() {
        return this.gt.nSamples();
    }

    @Override
    public Samples samples() {
        return this.gt.samples();
    }

    @Override
    public boolean isPhased() {
        return this.gt.isPhased();
    }

    @Override
    public int allele1(int n, int n2) {
        return this.gt.allele1(this.inclusionMap[n], n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.gt.allele2(this.inclusionMap[n], n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.gt.allele(this.inclusionMap[n], n2);
    }

    @Override
    public RestrictedGT restrict(Markers markers, int[] nArray) {
        return new RestrictedGT(this, markers, nArray);
    }

    @Override
    public RestrictedGT restrict(int n, int n2) {
        Markers markers = this.restrictedMarkers.restrict(n, n2);
        int[] nArray = IntStream.range(n, n2).toArray();
        return new RestrictedGT(this, markers, nArray);
    }

    public String toString() {
        return RestrictedGT.class.toString() + " : " + this.gt.toString();
    }
}

