/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Filter;
import blbutil.InputIt;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import main.Par;
import main.Pedigree;
import vcf.BasicGT;
import vcf.FilterUtil;
import vcf.GTRec;
import vcf.GeneticMap;
import vcf.IntervalVcfIt;
import vcf.Marker;
import vcf.MarkerIndices;
import vcf.Samples;
import vcf.SlidingWindow;
import vcf.VcfIt;
import vcf.Window;

public class TargSlidingWindow
implements SlidingWindow {
    private final SampleFileIt<GTRec> targIt;
    private final Pedigree ped;
    private final GeneticMap genMap;
    private final BlockingQueue<Window> q;
    private final Reader reader;
    private int cumTargMarkers;
    private boolean noMoreWindows;

    public static TargSlidingWindow instance(Par par) {
        TargSlidingWindow targSlidingWindow = new TargSlidingWindow(par);
        Thread thread = new Thread(targSlidingWindow.reader);
        thread.setDaemon(true);
        thread.start();
        return targSlidingWindow;
    }

    private TargSlidingWindow(Par par) {
        if (par.ref() != null) {
            throw new IllegalStateException("par.ref()=" + par.ref());
        }
        this.targIt = TargSlidingWindow.targIt(par);
        this.ped = new Pedigree(this.targIt.samples(), par.ped());
        this.genMap = GeneticMap.geneticMap(par.map(), par.chromInt());
        this.q = new ArrayBlockingQueue<Window>(1);
        this.reader = new Reader(par, this.genMap, this.targIt, this.q);
        this.cumTargMarkers = 0;
        this.noMoreWindows = false;
    }

    private static SampleFileIt<GTRec> targIt(Par par) {
        InputIt inputIt = InputIt.fromGzipFile(par.gt());
        Filter<String> filter = FilterUtil.sampleFilter(par.excludesamples());
        Filter<Marker> filter2 = FilterUtil.markerFilter(par.excludemarkers());
        SampleFileIt<GTRec> sampleFileIt = VcfIt.create(inputIt, filter, filter2, VcfIt.TO_LOWMEM_GT_REC);
        if (par.chromInt() != null) {
            sampleFileIt = new IntervalVcfIt<GTRec>(sampleFileIt, par.chromInt());
        }
        return sampleFileIt;
    }

    @Override
    public Samples targSamples() {
        return this.targIt.samples();
    }

    @Override
    public Pedigree ped() {
        return this.ped;
    }

    @Override
    public GeneticMap genMap() {
        return this.genMap;
    }

    @Override
    public int cumTargMarkers() {
        return this.cumTargMarkers;
    }

    @Override
    public int cumMarkers() {
        return this.cumTargMarkers;
    }

    @Override
    public Optional<Window> nextWindow() {
        if (this.noMoreWindows) {
            return Optional.empty();
        }
        Window window = SlidingWindow.takeFromQ(this.q);
        if (window.lastWindow()) {
            this.noMoreWindows = true;
        }
        this.cumTargMarkers += window.targGT().nMarkers();
        return Optional.of(window);
    }

    @Override
    public void close() {
        this.noMoreWindows = true;
        this.targIt.close();
    }

    public String toString() {
        return TargSlidingWindow.class.toString();
    }

    private static class Reader
    implements Runnable {
        private final GeneticMap genMap;
        private final float windowCM;
        private final float overlapCM;
        private final SampleFileIt<GTRec> targIt;
        private final BlockingQueue<Window> q;
        private final ArrayList<GTRec> overlap;
        private final ArrayList<GTRec> recs;
        private GTRec nextRec;

        public Reader(Par par, GeneticMap geneticMap, SampleFileIt<GTRec> sampleFileIt, BlockingQueue<Window> blockingQueue) {
            this.genMap = geneticMap;
            this.windowCM = par.window();
            this.overlapCM = par.overlap();
            this.targIt = sampleFileIt;
            this.q = blockingQueue;
            this.overlap = new ArrayList();
            this.recs = new ArrayList(10000);
        }

        @Override
        public void run() {
            try {
                if (!this.targIt.hasNext()) {
                    throw new IllegalArgumentException("Error: no genotype data");
                }
                this.nextRec = (GTRec)this.targIt.next();
                int n = 0;
                double d = Double.NaN;
                while (this.nextRec != null) {
                    int n2 = this.nextRec.marker().chromIndex();
                    d = this.nextEndCm(d);
                    int n3 = this.genMap.basePos(this.nextRec.marker().chromIndex(), d);
                    Window window = this.readWindow(n2, n3, ++n);
                    SlidingWindow.addToQ(this.q, window);
                    int n4 = window.indices().overlapStart();
                    this.overlap.addAll(this.recs.subList(n4, this.recs.size()));
                }
            }
            catch (Throwable throwable) {
                Utilities.exit(throwable);
            }
        }

        private double nextEndCm(double d) {
            d = this.overlap.isEmpty() ? this.genMap.genPos(this.nextRec.marker()) + (double)this.windowCM : (d += (double)(this.windowCM - this.overlapCM));
            return d;
        }

        private Window readWindow(int n, int n2, int n3) {
            int n4 = this.overlap.size();
            this.recs.clear();
            this.recs.addAll(this.overlap);
            this.overlap.clear();
            while (this.nextRec != null && this.nextRec.marker().chromIndex() == n && this.nextRec.marker().pos() < n2) {
                this.recs.add(this.nextRec);
                this.nextRec = this.targIt.hasNext() ? (GTRec)this.targIt.next() : null;
            }
            return this.window(n4, n, n3);
        }

        private Window window(int n, int n2, int n3) {
            BasicGT basicGT = new BasicGT(this.recs.toArray(new GTRec[0]));
            boolean bl = this.nextRec == null;
            boolean bl2 = this.nextRec == null || this.nextRec.marker().chromIndex() != n2;
            int n4 = this.targOverlapStart(basicGT, bl2, this.overlapCM);
            MarkerIndices markerIndices = new MarkerIndices(n, n4, basicGT.nMarkers());
            return new Window(this.genMap, n3, bl, markerIndices, null, basicGT);
        }

        private int targOverlapStart(BasicGT basicGT, boolean bl, float f) {
            if (bl) {
                return basicGT.nMarkers();
            }
            int n = basicGT.nMarkers() - 1;
            Marker marker = basicGT.marker(n);
            double d = this.genMap.genPos(marker);
            double d2 = d - (double)f;
            int n2 = this.genMap.basePos(marker.chromIndex(), d2);
            int n3 = 0;
            int n4 = n;
            while (n3 <= n4) {
                int n5 = n3 + n4 >>> 1;
                int n6 = basicGT.marker(n5).pos();
                if (n6 < n2) {
                    n3 = n5 + 1;
                    continue;
                }
                if (n6 > n2) {
                    n4 = n5 - 1;
                    continue;
                }
                return this.firstIndexWithPos(basicGT, n5);
            }
            assert (n4 < n3);
            return this.firstIndexWithPos(basicGT, Math.max(0, n4));
        }

        private int firstIndexWithPos(BasicGT basicGT, int n) {
            int n2 = basicGT.marker(n).pos();
            while (n > 0 && basicGT.marker(n - 1).pos() == n2) {
                --n;
            }
            return n;
        }
    }
}

