/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Const;
import blbutil.Filter;
import blbutil.StringUtil;
import blbutil.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import vcf.Samples;
import vcf.VcfMetaInfo;
import vcf.VcfRecGTParser;

public final class VcfHeader {
    public static final String HEADER_PREFIX = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";
    private static final int SAMPLE_OFFSET = 9;
    private final String src;
    private final VcfMetaInfo[] metaInfoLines;
    private final int nHeaderFields;
    private final int[] includedIndices;
    private final Samples samples;

    static boolean[] isDiploid(String string) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        int n = VcfRecGTParser.ninthTabPos(string) + 1;
        boolean bl = true;
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\t') {
                arrayList.add(!bl);
                bl = true;
                continue;
            }
            if (c != '/' && c != '|') continue;
            bl = false;
        }
        arrayList.add(!bl);
        boolean[] blArray = new boolean[arrayList.size()];
        for (n2 = 0; n2 < blArray.length; ++n2) {
            blArray[n2] = (Boolean)arrayList.get(n2);
        }
        return blArray;
    }

    public VcfHeader(String string, String[] stringArray, boolean[] blArray) {
        this(string, stringArray, blArray, Filter.acceptAllFilter());
    }

    public VcfHeader(String string, String[] stringArray, boolean[] blArray, Filter<String> filter) {
        if (string == null) {
            throw new NullPointerException(String.class.toString());
        }
        if (filter == null) {
            filter = Filter.acceptAllFilter();
        }
        VcfHeader.checkHeaderLines(stringArray, string);
        int n = stringArray.length - 1;
        this.src = string;
        this.metaInfoLines = new VcfMetaInfo[n];
        for (int i = 0; i < n; ++i) {
            this.metaInfoLines[i] = new VcfMetaInfo(stringArray[i]);
        }
        String[] stringArray2 = StringUtil.getFields(stringArray[n], '\t');
        this.nHeaderFields = stringArray2.length;
        this.includedIndices = VcfHeader.includedIndices(string, stringArray2, filter);
        this.samples = this.samples(stringArray2, blArray, this.includedIndices);
    }

    private static void checkHeaderLines(String[] stringArray, String string) {
        if (stringArray.length == 0) {
            String string2 = Const.nl + Const.nl + "ERROR: Missing the VCF meta information lines and the VCF header line" + Const.nl + "VCF source: " + string + Const.nl;
            throw new IllegalArgumentException(string2);
        }
        String string3 = stringArray[stringArray.length - 1];
        if (!string3.startsWith(HEADER_PREFIX)) {
            String string4 = Const.nl + Const.nl + "ERROR: Missing the VCF header line." + Const.nl + "VCF source: " + string + Const.nl + "The VCF header line must immediately follow the meta-information lines." + Const.nl + "The fields of the VCF header line must be tab-delimited and begin with:" + Const.nl + HEADER_PREFIX + Const.nl;
            throw new IllegalArgumentException(string4);
        }
    }

    private static int[] includedIndices(String string, String[] stringArray, Filter<String> filter) {
        int n = Math.max(stringArray.length - 9, 0);
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!filter.accept(stringArray[9 + i])) continue;
            nArray[n2++] = i;
        }
        if (n2 == 0) {
            String string2 = "All samples in the VCF file are excluded";
            String string3 = Const.nl + "Error      :  " + string2 + Const.nl + "File       :  " + string;
            Utilities.exit(new Throwable(string2), string3);
        }
        if (n2 < nArray.length) {
            nArray = Arrays.copyOf(nArray, n2);
        }
        return nArray;
    }

    private Samples samples(String[] stringArray, boolean[] blArray, int[] nArray) {
        String[] stringArray2 = new String[nArray.length];
        boolean[] blArray2 = new boolean[nArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[9 + nArray[i]];
            blArray2[i] = blArray[nArray[i]];
        }
        return Samples.fromIds(stringArray2, blArray2);
    }

    public String src() {
        return this.src;
    }

    public int nMetaInfoLines() {
        return this.metaInfoLines.length;
    }

    public VcfMetaInfo metaInfoLine(int n) {
        return this.metaInfoLines[n];
    }

    public int nHeaderFields() {
        return this.nHeaderFields;
    }

    public int nUnfilteredSamples() {
        return Math.max(0, this.nHeaderFields - 9);
    }

    public int unfilteredSampleIndex(int n) {
        return this.includedIndices[n];
    }

    public int nSamples() {
        return this.samples.size();
    }

    public Samples samples() {
        return this.samples;
    }

    public String[] sampleIds() {
        return this.samples.ids();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(400);
        for (int i = 0; i < this.metaInfoLines.length; ++i) {
            stringBuilder.append(this.metaInfoLines[i]);
            stringBuilder.append(Const.nl);
        }
        String[] stringArray = this.samples.ids();
        stringBuilder.append(HEADER_PREFIX);
        for (String string : stringArray) {
            stringBuilder.append('\t');
            stringBuilder.append(string);
        }
        stringBuilder.append(Const.nl);
        return stringBuilder.toString();
    }
}

