/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import ints.IntArray;
import ints.IntList;
import ints.WrappedIntArray;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import vcf.BasicGT;
import vcf.GeneticMap;
import vcf.MarkerIndices;
import vcf.RefGT;

public class Window {
    public static final IntArray ZERO_FREQ_ARRAY = new WrappedIntArray(new int[0]);
    public static final IntArray HIGH_FREQ_ARRAY = new WrappedIntArray(new int[0]);
    private final GeneticMap genMap;
    private final int windowIndex;
    private final boolean lastWindow;
    private final MarkerIndices indices;
    private final BasicGT targGT;
    private final RefGT refGT;
    private final RefGT restrictRefGT;

    public Window(GeneticMap geneticMap, int n, boolean bl, MarkerIndices markerIndices, RefGT refGT, BasicGT basicGT) {
        if (geneticMap == null) {
            throw new NullPointerException(GeneticMap.class.toString());
        }
        if (basicGT.nMarkers() != markerIndices.nTargMarkers()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        if (refGT != null && refGT.nMarkers() != markerIndices.nMarkers()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        this.genMap = geneticMap;
        this.windowIndex = n;
        this.lastWindow = bl;
        this.indices = markerIndices;
        this.targGT = basicGT;
        this.refGT = refGT;
        this.restrictRefGT = refGT == null ? null : refGT.restrict(basicGT.markers(), markerIndices.targMarkerToMarker());
    }

    public GeneticMap genMap() {
        return this.genMap;
    }

    public int chromIndex() {
        return this.targGT.marker(0).chromIndex();
    }

    public boolean lastWindow() {
        return this.lastWindow;
    }

    public int windowIndex() {
        return this.windowIndex;
    }

    public BasicGT targGT() {
        return this.targGT;
    }

    public Optional<RefGT> refGT() {
        return this.refGT == null ? Optional.empty() : Optional.of(this.refGT);
    }

    public Optional<RefGT> restrictRefGT() {
        return this.restrictRefGT == null ? Optional.empty() : Optional.of(this.restrictRefGT);
    }

    public MarkerIndices indices() {
        return this.indices;
    }

    public IntArray[][] carriers(int n3) {
        return (IntArray[][])IntStream.range(0, this.targGT.nMarkers()).parallel().mapToObj(n2 -> this.carriers(n2, n3)).toArray(n -> new IntArray[n][]);
    }

    private IntArray[] carriers(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = this.targGT.marker(n2).nAlleles();
        IntList[] intListArray = (IntList[])IntStream.range(0, n7).mapToObj(n -> new IntList(16)).toArray(IntList[]::new);
        int n8 = this.targGT.nSamples();
        int n9 = this.restrictRefGT != null ? this.restrictRefGT.nSamples() : 0;
        for (n6 = 0; n6 < n8; ++n6) {
            n5 = this.targGT.allele1(n2, n6);
            n4 = this.targGT.allele2(n2, n6);
            if (n5 >= 0 && intListArray[n5].size() <= n3) {
                intListArray[n5].add(n6);
            }
            if (n4 < 0 || n4 == n5 || intListArray[n4].size() > n3) continue;
            intListArray[n4].add(n6);
        }
        if (this.restrictRefGT != null) {
            for (n6 = 0; n6 < n9; ++n6) {
                n5 = this.restrictRefGT.allele1(n2, n6);
                n4 = this.restrictRefGT.allele2(n2, n6);
                if (n5 >= 0 && intListArray[n5].size() <= n3) {
                    intListArray[n5].add(n8 + n6);
                }
                if (n4 < 0 || n4 == n5 || intListArray[n4].size() > n3) continue;
                intListArray[n4].add(n8 + n6);
            }
        }
        return (IntArray[])Arrays.stream(intListArray).map(intList -> {
            if (intList.isEmpty()) {
                return ZERO_FREQ_ARRAY;
            }
            if (intList.size() <= n3) {
                return new WrappedIntArray((IntList)intList);
            }
            return HIGH_FREQ_ARRAY;
        }).toArray(IntArray[]::new);
    }
}

