/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.BitArray;
import blbutil.Const;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import phase.SamplePhase;
import vcf.GT;
import vcf.Marker;
import vcf.Markers;
import vcf.RestrictedGT;
import vcf.Samples;

public final class XRefGT
implements GT {
    private final Samples samples;
    private final Markers markers;
    private final BitArray[] haps;

    private XRefGT(Markers markers, Samples samples, BitArray[] bitArrayArray) {
        this.markers = markers;
        this.samples = samples;
        this.haps = bitArrayArray;
    }

    public static XRefGT combine(XRefGT xRefGT, XRefGT xRefGT2) {
        if (!xRefGT.markers().equals(xRefGT2.markers())) {
            throw new IllegalArgumentException("inconsisent data");
        }
        Samples samples = Samples.combine(xRefGT.samples(), xRefGT2.samples());
        Stream<BitArray> stream = Arrays.stream(xRefGT.haps);
        Stream<BitArray> stream2 = Arrays.stream(xRefGT2.haps);
        BitArray[] bitArrayArray = (BitArray[])((Stream)Stream.concat(stream, stream2).parallel()).toArray(BitArray[]::new);
        return new XRefGT(xRefGT.markers, samples, bitArrayArray);
    }

    public static XRefGT from(Markers markers, Samples samples, BitArray[] bitArrayArray) {
        int n = markers.sumHapBits();
        for (BitArray bitArray2 : bitArrayArray) {
            if (bitArray2.size() == n) continue;
            throw new IllegalArgumentException("inconsistent data");
        }
        if (samples.size() << 1 != bitArrayArray.length) {
            throw new IllegalArgumentException("inconsistent data");
        }
        BitArray[] bitArrayArray2 = (BitArray[])((Stream)Arrays.stream(bitArrayArray).parallel()).map(bitArray -> new BitArray((BitArray)bitArray)).toArray(BitArray[]::new);
        return new XRefGT(markers, samples, bitArrayArray2);
    }

    public static XRefGT from(Samples samples, AtomicReferenceArray<SamplePhase> atomicReferenceArray) {
        int n2 = atomicReferenceArray.length();
        if (n2 == 0 || samples.size() != n2) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        Markers markers = atomicReferenceArray.get(0).markers();
        BitArray[] bitArrayArray = (BitArray[])IntStream.range(0, n2 << 1).parallel().mapToObj(n -> {
            SamplePhase samplePhase = (SamplePhase)atomicReferenceArray.get(n >> 1);
            if (!samplePhase.markers().equals(markers)) {
                throw new IllegalArgumentException("inconsistent data");
            }
            return (n & 1) == 0 ? samplePhase.hap1() : samplePhase.hap2();
        }).toArray(BitArray[]::new);
        return new XRefGT(markers, samples, bitArrayArray);
    }

    public BitArray[] toBitLists(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int n3 = (this.markers.size() + n - 1) / n;
        while (n3 > 4096) {
            n3 = n3 + 1 >> 1;
        }
        int n4 = n3;
        int n5 = (this.markers.size() + (n4 - 1)) / n4;
        return (BitArray[])IntStream.range(0, n5).parallel().boxed().flatMap(n2 -> this.bitLists((int)n2, n4)).toArray(BitArray[]::new);
    }

    private Stream<BitArray> bitLists(int n2, int n3) {
        int n4 = n2 * n3;
        int n5 = Math.min(n4 + n3, this.markers.size());
        BitArray[] bitArrayArray = (BitArray[])IntStream.range(n4, n5).mapToObj(n -> new BitArray(this.haps.length * this.markers.marker(n).bitsPerAllele())).toArray(BitArray[]::new);
        int[] nArray = IntStream.range(n4, n5).map(n -> this.markers.marker(n).bitsPerAllele()).toArray();
        for (int i = 0; i < this.haps.length; ++i) {
            int n6 = this.markers.sumHapBits(n4);
            for (int j = n4; j < n5; ++j) {
                int n7 = j - n4;
                int n8 = nArray[n7];
                int n9 = i * n8;
                for (int k = 0; k < n8; ++k) {
                    if (!this.haps[i].get(n6++)) continue;
                    bitArrayArray[n7].set(n9 + k);
                }
            }
        }
        return Arrays.stream(bitArrayArray);
    }

    public static XRefGT fromPhasedGT(GT gT, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        BitArray[] bitArrayArray = XRefGT.hapData(gT, n);
        return new XRefGT(gT.markers(), gT.samples(), bitArrayArray);
    }

    private static BitArray[] hapData(GT gT, int n) {
        if (!gT.isPhased()) {
            throw new IllegalArgumentException(String.valueOf(gT));
        }
        int n3 = (gT.nHaps() + n - 1) / n;
        while (n3 > 4096) {
            n3 = n3 + 1 >> 1;
        }
        int n4 = n3;
        int n5 = (gT.nHaps() + (n4 - 1)) / n4;
        return (BitArray[])IntStream.range(0, n5).parallel().boxed().flatMap(n2 -> XRefGT.hapData(gT, n2, n4)).toArray(BitArray[]::new);
    }

    private static Stream<BitArray> hapData(GT gT, int n, int n3) {
        int n4 = gT.nMarkers();
        int n5 = gT.markers().sumHapBits();
        int n6 = n * n3;
        int n7 = Math.min(n6 + n3, gT.nHaps());
        BitArray[] bitArrayArray = (BitArray[])IntStream.range(0, n7 - n6).mapToObj(n2 -> new BitArray(n5)).toArray(BitArray[]::new);
        for (int i = 0; i < n4; ++i) {
            XRefGT.setHapData(gT, i, bitArrayArray, n6);
        }
        return Arrays.stream(bitArrayArray);
    }

    private static void setHapData(GT gT, int n, BitArray[] bitArrayArray, int n2) {
        assert (gT.isPhased());
        Markers markers = gT.markers();
        int n3 = markers.sumHapBits(n);
        int n4 = markers.sumHapBits(n + 1);
        for (int i = 0; i < bitArrayArray.length; ++i) {
            int n5 = gT.allele(n, n2 + i);
            long l = 1L;
            for (int j = n3; j < n4; ++j) {
                if (((long)n5 & l) == l) {
                    assert (j < bitArrayArray[i].size());
                    bitArrayArray[i].set(j);
                }
                l <<= 1;
            }
        }
    }

    public int hash(int n, int n2, int n3) {
        int n4 = this.markers.sumHapBits(n2);
        int n5 = this.markers.sumHapBits(n3);
        if (n5 - n4 == 1) {
            return this.haps[n].getAsInt(n4);
        }
        return this.haps[n].hash(n4, n5);
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public int nMarkers() {
        return this.markers.size();
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nHaps() {
        return this.haps.length;
    }

    @Override
    public int nSamples() {
        return this.samples.size();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public int allele1(int n, int n2) {
        return this.markers.allele(this.haps[n2 << 1], n);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.markers.allele(this.haps[n2 << 1 | 1], n);
    }

    @Override
    public int allele(int n, int n2) {
        return this.markers.allele(this.haps[n2], n);
    }

    @Override
    public GT restrict(Markers markers, int[] nArray) {
        return new RestrictedGT(this, markers, nArray);
    }

    @Override
    public XRefGT restrict(int n, int n2) {
        Markers markers = this.markers.restrict(n, n2);
        int n4 = this.markers.sumHapBits(n);
        int n5 = this.markers.sumHapBits(n2);
        BitArray[] bitArrayArray = (BitArray[])IntStream.range(0, this.haps.length).parallel().mapToObj(n3 -> this.haps[n3].restrict(n4, n5)).toArray(BitArray[]::new);
        return new XRefGT(markers, this.samples, bitArrayArray);
    }

    public void copyTo(int n, int n2, int n3, BitArray bitArray) {
        int n4 = this.markers.sumHapBits(n2);
        int n5 = this.markers.sumHapBits(n3);
        bitArray.copyFrom(this.haps[n], n4, n5);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(" nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        stringBuilder.append(Const.nl);
        int n = this.markers.size();
        int n2 = this.samples.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.markers.marker(i));
            stringBuilder.append(Const.nl);
            stringBuilder.append('.');
            stringBuilder.append('\t');
            stringBuilder.append("PASS");
            stringBuilder.append('\t');
            stringBuilder.append('.');
            stringBuilder.append('\t');
            stringBuilder.append("GT");
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append('\t');
                stringBuilder.append(this.allele1(i, j));
                stringBuilder.append('|');
                stringBuilder.append(this.allele2(i, j));
            }
        }
        stringBuilder.append(Const.nl);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

