/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Analysis;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import uk.ac.babraham.FastQC.Analysis.AnalysisListener;
import uk.ac.babraham.FastQC.Analysis.AnalysisRunner;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;

public class AnalysisQueue
implements Runnable,
AnalysisListener {
    private static AnalysisQueue instance = new AnalysisQueue();
    private LinkedBlockingDeque<AnalysisRunner> queue = new LinkedBlockingDeque();
    private AtomicInteger availableSlots = new AtomicInteger(1);
    private AtomicInteger usedSlots = new AtomicInteger(0);

    public static AnalysisQueue getInstance() {
        return instance;
    }

    private AnalysisQueue() {
        if (FastQCConfig.getInstance().threads != null) {
            this.availableSlots.set(FastQCConfig.getInstance().threads);
        }
        Thread t = new Thread(this);
        t.start();
    }

    public void addToQueue(AnalysisRunner runner) {
        this.queue.add(runner);
    }

    public void run() {
        while (true) {
            if (this.availableSlots.intValue() > this.usedSlots.intValue() && this.queue.size() > 0) {
                this.usedSlots.incrementAndGet();
                AnalysisRunner currentRun = this.queue.getFirst();
                this.queue.removeFirst();
                currentRun.addAnalysisListener(this);
                Thread t = new Thread(currentRun);
                t.start();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void analysisComplete(SequenceFile file, QCModule[] results) {
        this.usedSlots.decrementAndGet();
    }

    public void analysisUpdated(SequenceFile file, int sequencesProcessed, int percentComplete) {
    }

    public void analysisExceptionReceived(SequenceFile file, Exception e) {
        this.usedSlots.decrementAndGet();
    }

    public void analysisStarted(SequenceFile file) {
    }
}

