/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Analysis;

import java.util.ArrayList;
import java.util.List;
import uk.ac.babraham.FastQC.Analysis.AnalysisListener;
import uk.ac.babraham.FastQC.Analysis.AnalysisQueue;
import uk.ac.babraham.FastQC.Modules.BasicStats;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;

public class AnalysisRunner
implements Runnable {
    private SequenceFile file;
    private QCModule[] modules;
    private List<AnalysisListener> listeners = new ArrayList<AnalysisListener>();
    private int percentComplete = 0;

    public AnalysisRunner(SequenceFile file) {
        this.file = file;
    }

    public void addAnalysisListener(AnalysisListener l) {
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeAnalysisListener(AnalysisListener l) {
        if (l != null && this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public void startAnalysis(QCModule[] modules) {
        this.modules = modules;
        int i = 0;
        while (i < modules.length) {
            modules[i].reset();
            ++i;
        }
        AnalysisQueue.getInstance().addToQueue(this);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().analysisStarted(this.file);
        }
        seqCount = 0;
        while (this.file.hasNext()) {
            block14: {
                ++seqCount;
                try {
                    seq = this.file.next();
                    break block14;
                }
                catch (SequenceFormatException e) {
                    i = this.listeners.iterator();
                    ** while (i.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    i.next().analysisExceptionReceived(this.file, e);
                    continue;
                }
lbl16:
                // 1 sources

                return;
            }
            m = 0;
            while (m < this.modules.length) {
                if (!seq.isFiltered() || !this.modules[m].ignoreFilteredSequences()) {
                    this.modules[m].processSequence(seq);
                }
                ++m;
            }
            if (seqCount % 1000 != 0 || this.file.getPercentComplete() < this.percentComplete + 5) continue;
            this.percentComplete = this.file.getPercentComplete() / 5 * 5;
            i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().analysisUpdated(this.file, seqCount, this.percentComplete);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException var4_7) {
                // empty catch block
            }
        }
        if (seqCount == 0) {
            m = 0;
            while (m < this.modules.length) {
                if (this.modules[m] instanceof BasicStats) {
                    ((BasicStats)this.modules[m]).setFileName(this.file.name());
                }
                ++m;
            }
        }
        i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().analysisComplete(this.file, this.modules);
        }
    }
}

