/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Analysis;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import uk.ac.babraham.FastQC.Analysis.AnalysisListener;
import uk.ac.babraham.FastQC.Analysis.AnalysisRunner;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Modules.ModuleFactory;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.SequenceFactory;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Utilities.CasavaBasename;
import uk.ac.babraham.FastQC.Utilities.NanoporeBasename;

public class OfflineRunner
implements AnalysisListener {
    private AtomicInteger filesRemaining;
    private boolean showUpdates = true;

    public OfflineRunner(String[] filenames) {
        File[][] fileGroups;
        this.showUpdates = !FastQCConfig.getInstance().quiet;
        Vector<File> files = new Vector<File>();
        if (filenames.length == 1 && filenames[0].startsWith("stdin")) {
            files.add(new File(filenames[0]));
        } else {
            int f = 0;
            while (f < filenames.length) {
                File file = new File(filenames[f]);
                if (!file.exists() || !file.canRead()) {
                    System.err.println("Skipping '" + filenames[f] + "' which didn't exist, or couldn't be read");
                } else if (FastQCConfig.getInstance().nano && file.isDirectory()) {
                    File[] fast5files = file.listFiles();
                    int i = 0;
                    while (i < fast5files.length) {
                        if (fast5files[i].getName().endsWith(".fast5")) {
                            files.add(fast5files[i]);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < fast5files.length) {
                        if (fast5files[i].isDirectory()) {
                            File[] subFast5files = fast5files[i].listFiles();
                            int j = 0;
                            while (j < subFast5files.length) {
                                if (subFast5files[j].getName().endsWith(".fast5")) {
                                    files.add(subFast5files[j]);
                                }
                                ++i;
                            }
                        }
                        ++i;
                    }
                } else {
                    files.add(file);
                }
                ++f;
            }
        }
        if (FastQCConfig.getInstance().casava) {
            fileGroups = CasavaBasename.getCasavaGroups(files.toArray(new File[0]));
        } else if (FastQCConfig.getInstance().nano) {
            fileGroups = NanoporeBasename.getNanoporeGroups(files.toArray(new File[0]));
        } else {
            fileGroups = new File[files.size()][1];
            int f = 0;
            while (f < files.size()) {
                fileGroups[f][0] = (File)files.elementAt(f);
                ++f;
            }
        }
        this.filesRemaining = new AtomicInteger(fileGroups.length);
        boolean somethingFailed = false;
        int i = 0;
        while (i < fileGroups.length) {
            try {
                this.processFile(fileGroups[i]);
            }
            catch (OutOfMemoryError e) {
                System.err.println("Ran out of memory for " + fileGroups[i][0]);
                e.printStackTrace();
                System.exit(2);
            }
            catch (Exception e) {
                System.err.println("Failed to process " + fileGroups[i][0]);
                e.printStackTrace();
                this.filesRemaining.decrementAndGet();
                somethingFailed = true;
            }
            ++i;
        }
        while (this.filesRemaining.intValue() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (somethingFailed) {
            System.exit(1);
        }
        System.exit(0);
    }

    public void processFile(File[] files) throws Exception {
        int f = 0;
        while (f < files.length) {
            if (!files[f].getName().startsWith("stdin") && !files[f].exists()) {
                throw new IOException(String.valueOf(files[f].getName()) + " doesn't exist");
            }
            ++f;
        }
        SequenceFile sequenceFile = SequenceFactory.getSequenceFile(files);
        AnalysisRunner runner = new AnalysisRunner(sequenceFile);
        runner.addAnalysisListener(this);
        QCModule[] module_list = ModuleFactory.getStandardModuleList();
        runner.startAnalysis(module_list);
    }

    public void analysisComplete(SequenceFile file, QCModule[] results) {
        File reportFile;
        if (this.showUpdates) {
            System.out.println("Analysis complete for " + file.name());
        }
        if (FastQCConfig.getInstance().output_dir != null) {
            String fileName = String.valueOf(file.getFile().getName().replaceAll("stdin:", "").replaceAll("\\.gz$", "").replaceAll("\\.bz2$", "").replaceAll("\\.txt$", "").replaceAll("\\.fastq$", "").replaceAll("\\.fq$", "").replaceAll("\\.csfastq$", "").replaceAll("\\.sam$", "").replaceAll("\\.bam$", "")) + "_fastqc.html";
            reportFile = new File(FastQCConfig.getInstance().output_dir + "/" + fileName);
        } else {
            reportFile = new File(String.valueOf(file.getFile().getAbsolutePath().replaceAll("stdin:", "").replaceAll("\\.gz$", "").replaceAll("\\.bz2$", "").replaceAll("\\.txt$", "").replaceAll("\\.fastq$", "").replaceAll("\\.fq$", "").replaceAll("\\.csfastq$", "").replaceAll("\\.sam$", "").replaceAll("\\.bam$", "")) + "_fastqc.html");
        }
        try {
            new HTMLReportArchive(file, results, reportFile);
        }
        catch (Exception e) {
            this.analysisExceptionReceived(file, e);
            return;
        }
        this.filesRemaining.decrementAndGet();
    }

    public void analysisUpdated(SequenceFile file, int sequencesProcessed, int percentComplete) {
        if (percentComplete % 5 == 0) {
            if (percentComplete == 105 && this.showUpdates) {
                System.err.println("It seems our guess for the total number of records wasn't very good.  Sorry about that.");
            }
            if (percentComplete > 100) {
                if (this.showUpdates) {
                    System.err.println("Still going at " + percentComplete + "% complete for " + file.name());
                }
            } else if (this.showUpdates) {
                System.err.println("Approx " + percentComplete + "% complete for " + file.name());
            }
        }
    }

    public void analysisExceptionReceived(SequenceFile file, Exception e) {
        System.err.println("Failed to process file " + file.name());
        e.printStackTrace();
        this.filesRemaining.decrementAndGet();
    }

    public void analysisStarted(SequenceFile file) {
        if (this.showUpdates) {
            System.err.println("Started analysis of " + file.name());
        }
    }
}

