/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC;

import java.io.File;

public class FastQCConfig {
    private static FastQCConfig instance = new FastQCConfig();
    public boolean nogroup = false;
    public boolean expgroup = false;
    public boolean quiet = false;
    public boolean show_version = false;
    public Integer kmer_size = null;
    public Integer threads = null;
    public boolean showUpdates = true;
    public File output_dir = null;
    public boolean casava = false;
    public boolean nano = false;
    public boolean nofilter = false;
    public Boolean do_unzip = null;
    public String lineSeparator = System.getProperty("line.separator");
    public String sequence_format = null;
    public File contaminant_file = null;
    public File adapter_file = null;
    public File limits_file = null;
    public int minLength = 0;

    private FastQCConfig() {
        if (System.getProperty("fastqc.output_dir") != null) {
            this.output_dir = new File(System.getProperty("fastqc.output_dir"));
            if (!this.output_dir.exists() || !this.output_dir.canWrite()) {
                throw new IllegalArgumentException("Output dir " + this.output_dir + " doesn't exist or isn't writeable");
            }
        }
        if (System.getProperty("fastqc.contaminant_file") != null) {
            this.contaminant_file = new File(System.getProperty("fastqc.contaminant_file"));
            if (!this.contaminant_file.exists() || !this.contaminant_file.canRead()) {
                throw new IllegalArgumentException("Contaminant file " + this.contaminant_file + " doesn't exist or can't be read");
            }
        }
        if (System.getProperty("fastqc.adapter_file") != null) {
            this.adapter_file = new File(System.getProperty("fastqc.adapter_file"));
            if (!this.adapter_file.exists() || !this.adapter_file.canRead()) {
                throw new IllegalArgumentException("Adapter file " + this.adapter_file + " doesn't exist or can't be read");
            }
        }
        if (System.getProperty("fastqc.limits_file") != null) {
            this.limits_file = new File(System.getProperty("fastqc.limits_file"));
            if (!this.limits_file.exists() || !this.limits_file.canRead()) {
                throw new IllegalArgumentException("Limits file " + this.limits_file + " doesn't exist or can't be read");
            }
        }
        if (System.getProperty("fastqc.threads") != null) {
            this.threads = Integer.parseInt(System.getProperty("fastqc.threads"));
            if (this.threads < 1) {
                throw new IllegalArgumentException("Number of threads must be >= 1");
            }
        }
        if (System.getProperty("fastqc.kmer_size") != null) {
            this.kmer_size = Integer.parseInt(System.getProperty("fastqc.kmer_size"));
        }
        if (System.getProperty("fastqc.min_length") != null) {
            this.minLength = Integer.parseInt(System.getProperty("fastqc.min_length"));
        }
        if (System.getProperty("fastqc.quiet") != null && System.getProperty("fastqc.quiet").equals("true")) {
            this.quiet = true;
        }
        if (System.getProperty("fastqc.casava") != null && System.getProperty("fastqc.casava").equals("true")) {
            this.casava = true;
        }
        if (System.getProperty("fastqc.nano") != null && System.getProperty("fastqc.nano").equals("true")) {
            this.nano = true;
        }
        if (System.getProperty("fastqc.nofilter") != null && System.getProperty("fastqc.nofilter").equals("true")) {
            this.nofilter = true;
        }
        if (System.getProperty("fastqc.nogroup") != null && System.getProperty("fastqc.nogroup").equals("true")) {
            this.nogroup = true;
        }
        if (System.getProperty("fastqc.expgroup") != null && System.getProperty("fastqc.expgroup").equals("true")) {
            this.expgroup = true;
        }
        if (System.getProperty("fastqc.unzip") != null && System.getProperty("fastqc.unzip").equals("true")) {
            this.do_unzip = true;
        }
        if (System.getProperty("fastqc.sequence_format") != null) {
            this.setSequenceFormat(System.getProperty("fastqc.sequence_format"));
        }
    }

    public void setSequenceFormat(String sequenceFormat) {
        if (!(sequenceFormat.equals("fastq") || sequenceFormat.equals("sam") || sequenceFormat.equals("bam") || sequenceFormat.equals("sam_mapped") || sequenceFormat.equals("bam_mapped"))) {
            throw new IllegalArgumentException("Sequence format '" + sequenceFormat + "' wasn't recognised");
        }
        this.sequence_format = sequenceFormat;
    }

    public void setCasavaMode(boolean casava) {
        this.casava = casava;
    }

    public static FastQCConfig getInstance() {
        return instance;
    }
}

