/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Graphs;

import java.util.Vector;
import uk.ac.babraham.FastQC.FastQCConfig;

public class BaseGroup {
    private int lowerCount;
    private int upperCount;

    public static BaseGroup[] makeBaseGroups(int maxLength) {
        if (FastQCConfig.getInstance().minLength > maxLength) {
            maxLength = FastQCConfig.getInstance().minLength;
        }
        if (FastQCConfig.getInstance().nogroup) {
            return BaseGroup.makeUngroupedGroups(maxLength);
        }
        if (FastQCConfig.getInstance().nogroup) {
            return BaseGroup.makeUngroupedGroups(maxLength);
        }
        if (FastQCConfig.getInstance().expgroup) {
            return BaseGroup.makeExponentialBaseGroups(maxLength);
        }
        return BaseGroup.makeLinearBaseGroups(maxLength);
    }

    public static BaseGroup[] makeUngroupedGroups(int maxLength) {
        int startingBase = 1;
        int interval = 1;
        Vector<BaseGroup> groups = new Vector<BaseGroup>();
        while (startingBase <= maxLength) {
            int endBase = startingBase + (interval - 1);
            if (endBase > maxLength) {
                endBase = maxLength;
            }
            BaseGroup bg = new BaseGroup(startingBase, endBase);
            groups.add(bg);
            startingBase += interval;
        }
        return groups.toArray(new BaseGroup[0]);
    }

    public static BaseGroup[] makeExponentialBaseGroups(int maxLength) {
        int startingBase = 1;
        int interval = 1;
        Vector<BaseGroup> groups = new Vector<BaseGroup>();
        while (startingBase <= maxLength) {
            int endBase = startingBase + (interval - 1);
            if (endBase > maxLength) {
                endBase = maxLength;
            }
            BaseGroup bg = new BaseGroup(startingBase, endBase);
            groups.add(bg);
            if ((startingBase += interval) == 10 && maxLength > 75) {
                interval = 5;
            }
            if (startingBase == 50 && maxLength > 200) {
                interval = 10;
            }
            if (startingBase == 100 && maxLength > 300) {
                interval = 50;
            }
            if (startingBase == 500 && maxLength > 1000) {
                interval = 100;
            }
            if (startingBase != 1000 || maxLength <= 2000) continue;
            interval = 500;
        }
        return groups.toArray(new BaseGroup[0]);
    }

    private static int getLinearInterval(int length) {
        int[] baseValues = new int[]{2, 5, 10};
        int multiplier = 1;
        do {
            int b = 0;
            while (b < baseValues.length) {
                int interval = baseValues[b] * multiplier;
                int groupCount = 9 + (length - 9) / interval;
                if ((length - 9) % interval != 0) {
                    ++groupCount;
                }
                if (groupCount < 75) {
                    return interval;
                }
                ++b;
            }
        } while ((multiplier *= 10) != 10000000);
        throw new IllegalStateException("Couldn't find a sensible interval grouping for length '" + length + "'");
    }

    public static BaseGroup[] makeLinearBaseGroups(int maxLength) {
        if (maxLength <= 75) {
            return BaseGroup.makeUngroupedGroups(maxLength);
        }
        int interval = BaseGroup.getLinearInterval(maxLength);
        int startingBase = 1;
        Vector<BaseGroup> groups = new Vector<BaseGroup>();
        while (startingBase <= maxLength) {
            int endBase = startingBase + (interval - 1);
            if (startingBase < 10) {
                endBase = startingBase;
            }
            if (startingBase == 10 && interval > 10) {
                endBase = interval - 1;
            }
            if (endBase > maxLength) {
                endBase = maxLength;
            }
            BaseGroup bg = new BaseGroup(startingBase, endBase);
            groups.add(bg);
            if (startingBase < 10) {
                ++startingBase;
                continue;
            }
            if (startingBase == 10 && interval > 10) {
                startingBase = interval;
                continue;
            }
            startingBase += interval;
        }
        return groups.toArray(new BaseGroup[0]);
    }

    private BaseGroup(int lowerCount, int upperCount) {
        this.lowerCount = lowerCount;
        this.upperCount = upperCount;
    }

    public int lowerCount() {
        return this.lowerCount;
    }

    public int upperCount() {
        return this.upperCount;
    }

    public boolean containsValue(int value) {
        return value >= this.lowerCount && value <= this.upperCount;
    }

    public String toString() {
        if (this.lowerCount == this.upperCount) {
            return "" + this.lowerCount;
        }
        return this.lowerCount + "-" + this.upperCount;
    }
}

