/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Graphs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class LineGraph
extends JPanel {
    private String[] xTitles;
    private String xLabel;
    private String[] xCategories;
    private double[][] data;
    private String graphTitle;
    private double minY;
    private double maxY;
    private double yInterval;
    private static final Color[] COLOURS = new Color[]{new Color(220, 0, 0), new Color(0, 0, 220), new Color(0, 220, 0), Color.DARK_GRAY, Color.MAGENTA, Color.ORANGE, Color.YELLOW, Color.CYAN, Color.PINK, Color.LIGHT_GRAY};

    public LineGraph(double[][] data, double minY, double maxY, String xLabel, String[] xTitles, int[] xCategories, String graphTitle) {
        this(data, minY, maxY, xLabel, xTitles, new String[0], graphTitle);
        this.xCategories = new String[xCategories.length];
        int i = 0;
        while (i < xCategories.length) {
            this.xCategories[i] = "" + xCategories[i];
            ++i;
        }
    }

    public LineGraph(double[][] data, double minY, double maxY, String xLabel, String[] xTitles, String[] xCategories, String graphTitle) {
        this.data = data;
        this.minY = minY;
        this.maxY = maxY;
        this.xTitles = xTitles;
        this.xLabel = xLabel;
        this.xCategories = xCategories;
        this.graphTitle = graphTitle;
        this.yInterval = this.findOptimalYInterval(maxY);
    }

    private double findOptimalYInterval(double max) {
        int base = 1;
        double[] divisions = new double[]{1.0, 2.0, 2.5, 5.0};
        while (true) {
            int d = 0;
            while (d < divisions.length) {
                double tester = (double)base * divisions[d];
                if (max / tester <= 10.0) {
                    return tester;
                }
                ++d;
            }
            base *= 10;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 200);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        int lastY = 0;
        double yStart = this.minY % this.yInterval == 0.0 ? this.minY : this.yInterval * ((double)((int)this.minY) / this.yInterval + 1.0);
        int xOffset = 0;
        double i = yStart;
        while (i <= this.maxY) {
            String label = "" + i;
            label = label.replaceAll(".0$", "");
            int width = g.getFontMetrics().stringWidth(label);
            if (width > xOffset) {
                xOffset = width;
            }
            g.drawString(label, 2, this.getY(i) + g.getFontMetrics().getAscent() / 2);
            i += this.yInterval;
        }
        int titleWidth = g.getFontMetrics().stringWidth(this.graphTitle);
        g.drawString(this.graphTitle, (xOffset += 5) + (this.getWidth() - (xOffset + 10)) / 2 - titleWidth / 2, 30);
        g.drawLine(xOffset, this.getHeight() - 40, this.getWidth() - 10, this.getHeight() - 40);
        g.drawLine(xOffset, this.getHeight() - 40, xOffset, 40);
        g.drawString(this.xLabel, this.getWidth() / 2 - g.getFontMetrics().stringWidth(this.xLabel) / 2, this.getHeight() - 5);
        int baseWidth = (this.getWidth() - (xOffset + 10)) / Math.max(this.data[0].length, 1);
        if (baseWidth < 1) {
            baseWidth = 1;
        }
        int lastXLabelEnd = 0;
        int i2 = 0;
        while (i2 < this.data[0].length) {
            if (i2 % 2 != 0) {
                g.setColor(new Color(230, 230, 230));
                g.fillRect(xOffset + baseWidth * i2, 40, baseWidth, this.getHeight() - 80);
            }
            g.setColor(Color.BLACK);
            String baseNumber = this.xCategories[i2];
            int baseNumberWidth = g.getFontMetrics().stringWidth(baseNumber);
            int baseNumberPosition = baseWidth / 2 + xOffset + baseWidth * i2 - baseNumberWidth / 2;
            if (baseNumberPosition > lastXLabelEnd) {
                g.drawString(baseNumber, baseNumberPosition, this.getHeight() - 25);
                lastXLabelEnd = baseNumberPosition + baseNumberWidth + 5;
            }
            ++i2;
        }
        g.setColor(new Color(180, 180, 180));
        double i22 = yStart;
        while (i22 <= this.maxY) {
            g.drawLine(xOffset, this.getY(i22), this.getWidth() - 10, this.getY(i22));
            i22 += this.yInterval;
        }
        g.setColor(Color.BLACK);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int d = 0;
        while (d < this.data.length) {
            g.setColor(COLOURS[d % COLOURS.length]);
            if (this.data[d].length > 0) {
                lastY = this.getY(this.data[d][0]);
            }
            int i3 = 1;
            while (i3 < this.data[d].length) {
                int thisY = this.getY(this.data[d][i3]);
                g.drawLine(baseWidth / 2 + xOffset + baseWidth * (i3 - 1), lastY, baseWidth / 2 + xOffset + baseWidth * i3, thisY);
                lastY = thisY;
                ++i3;
            }
            ++d;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        int widestLabel = 0;
        int t = 0;
        while (t < this.xTitles.length) {
            int width = g.getFontMetrics().stringWidth(this.xTitles[t]);
            if (width > widestLabel) {
                widestLabel = width;
            }
            ++t;
        }
        g.setColor(Color.WHITE);
        g.fillRect(this.getWidth() - 10 - (widestLabel += 6), 40, widestLabel, 3 + 20 * this.xTitles.length);
        g.setColor(Color.LIGHT_GRAY);
        g.drawRect(this.getWidth() - 10 - widestLabel, 40, widestLabel, 3 + 20 * this.xTitles.length);
        t = 0;
        while (t < this.xTitles.length) {
            g.setColor(COLOURS[t % COLOURS.length]);
            g.drawString(this.xTitles[t], this.getWidth() - 10 - widestLabel + 3, 40 + 20 * (t + 1));
            ++t;
        }
    }

    private int getY(double y) {
        return this.getHeight() - 40 - (int)((double)(this.getHeight() - 80) / (this.maxY - this.minY) * y);
    }
}

