/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Graphs;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class QualityBoxPlot
extends JPanel {
    private double[] means;
    private double[] medians;
    private double[] lowest;
    private double[] highest;
    private double[] lowerQuartile;
    private double[] upperQuartile;
    private String[] xLabels;
    private String graphTitle;
    private double minY;
    private double maxY;
    private double yInterval;
    private static final Color GOOD = new Color(195, 230, 195);
    private static final Color BAD = new Color(230, 220, 195);
    private static final Color UGLY = new Color(230, 195, 195);
    private static final Color GOOD_DARK = new Color(175, 230, 175);
    private static final Color BAD_DARK = new Color(230, 215, 175);
    private static final Color UGLY_DARK = new Color(230, 175, 175);

    public QualityBoxPlot(double[] means, double[] medians, double[] lowest, double[] highest, double[] lowerQuartile, double[] upperQuartile, double minY, double maxY, double yInterval, String[] xLabels, String graphTitle) {
        this.means = means;
        this.medians = medians;
        this.lowest = lowest;
        this.highest = highest;
        this.lowerQuartile = lowerQuartile;
        this.upperQuartile = upperQuartile;
        this.minY = minY;
        this.maxY = maxY;
        this.yInterval = yInterval;
        this.xLabels = xLabels;
        this.graphTitle = graphTitle;
        this.yInterval = yInterval;
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        int lastY = 0;
        double yStart = this.minY % this.yInterval == 0.0 ? this.minY : this.yInterval * ((double)((int)this.minY) / this.yInterval + 1.0);
        int xOffset = 0;
        double i = yStart;
        while (i <= this.maxY) {
            String label = "" + i;
            label = label.replaceAll(".0$", "");
            int width = g.getFontMetrics().stringWidth(label);
            if (width > xOffset) {
                xOffset = width;
            }
            g.drawString(label, 2, this.getY(i) + g.getFontMetrics().getAscent() / 2);
            i += this.yInterval;
        }
        g.setColor(Color.BLACK);
        int titleWidth = g.getFontMetrics().stringWidth(this.graphTitle);
        g.drawString(this.graphTitle, (xOffset += 5) + (this.getWidth() - (xOffset + 10)) / 2 - titleWidth / 2, 30);
        int baseWidth = (this.getWidth() - (xOffset + 10)) / this.means.length;
        if (baseWidth < 1) {
            baseWidth = 1;
        }
        int lastXLabelEnd = 0;
        int i2 = 0;
        while (i2 < this.means.length) {
            if (i2 % 2 != 0) {
                g.setColor(UGLY);
            } else {
                g.setColor(UGLY_DARK);
            }
            g.fillRect(xOffset + baseWidth * i2, this.getY(20.0), baseWidth, this.getY(yStart) - this.getY(20.0));
            if (i2 % 2 != 0) {
                g.setColor(BAD);
            } else {
                g.setColor(BAD_DARK);
            }
            g.fillRect(xOffset + baseWidth * i2, this.getY(28.0), baseWidth, this.getY(20.0) - this.getY(28.0));
            if (i2 % 2 != 0) {
                g.setColor(GOOD);
            } else {
                g.setColor(GOOD_DARK);
            }
            g.fillRect(xOffset + baseWidth * i2, this.getY(this.maxY), baseWidth, this.getY(28.0) - this.getY(this.maxY));
            g.setColor(Color.BLACK);
            int baseNumberWidth = g.getFontMetrics().stringWidth(this.xLabels[i2]);
            int labelStart = baseWidth / 2 + xOffset + baseWidth * i2 - baseNumberWidth / 2;
            if (labelStart > lastXLabelEnd) {
                g.drawString(this.xLabels[i2], labelStart, this.getHeight() - 25);
                lastXLabelEnd = labelStart + g.getFontMetrics().stringWidth(this.xLabels[i2]) + 5;
            }
            ++i2;
        }
        g.drawLine(xOffset, this.getHeight() - 40, this.getWidth() - 10, this.getHeight() - 40);
        g.drawLine(xOffset, this.getHeight() - 40, xOffset, 40);
        g.drawString("Position in read (bp)", this.getWidth() / 2 - g.getFontMetrics().stringWidth("Position in read (bp)") / 2, this.getHeight() - 5);
        i2 = 0;
        while (i2 < this.medians.length) {
            int boxBottomY = this.getY(this.lowerQuartile[i2]);
            int boxTopY = this.getY(this.upperQuartile[i2]);
            int lowerWhiskerY = this.getY(this.lowest[i2]);
            int upperWhiskerY = this.getY(this.highest[i2]);
            int medianY = this.getY(this.medians[i2]);
            g.setColor(new Color(240, 240, 0));
            g.fillRect(xOffset + baseWidth * i2 + 2, boxTopY, baseWidth - 4, boxBottomY - boxTopY);
            g.setColor(Color.BLACK);
            g.drawRect(xOffset + baseWidth * i2 + 2, boxTopY, baseWidth - 4, boxBottomY - boxTopY);
            g.drawLine(xOffset + baseWidth * i2 + baseWidth / 2, upperWhiskerY, xOffset + baseWidth * i2 + baseWidth / 2, boxTopY);
            g.drawLine(xOffset + baseWidth * i2 + 2, upperWhiskerY, xOffset + baseWidth * (i2 + 1) - 2, upperWhiskerY);
            g.drawLine(xOffset + baseWidth * i2 + baseWidth / 2, lowerWhiskerY, xOffset + baseWidth * i2 + baseWidth / 2, boxBottomY);
            g.drawLine(xOffset + baseWidth * i2 + 2, lowerWhiskerY, xOffset + baseWidth * (i2 + 1) - 2, lowerWhiskerY);
            g.setColor(new Color(200, 0, 0));
            g.drawLine(xOffset + baseWidth * i2 + 2, medianY, xOffset + baseWidth * (i2 + 1) - 2, medianY);
            ++i2;
        }
        g.setColor(new Color(0, 0, 200));
        lastY = this.getY(this.means[0]);
        i2 = 1;
        while (i2 < this.means.length) {
            int thisY = this.getY(this.means[i2]);
            g.drawLine(baseWidth / 2 + xOffset + baseWidth * (i2 - 1), lastY, baseWidth / 2 + xOffset + baseWidth * i2, thisY);
            lastY = thisY;
            ++i2;
        }
    }

    public int getY(double y) {
        return this.getHeight() - 40 - (int)((double)(this.getHeight() - 80) / (this.maxY - this.minY) * (y - this.minY));
    }
}

