/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Graphs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Utilities.HotColdColourGradient;

public class TileGraph
extends JPanel {
    private String[] xLabels;
    private int[] tiles;
    private double[][] tileBaseMeans;
    private HotColdColourGradient gradient = new HotColdColourGradient();

    public TileGraph(String[] xLabels, int[] tiles, double[][] tileBaseMeans) {
        this.xLabels = xLabels;
        this.tiles = tiles;
        this.tileBaseMeans = tileBaseMeans;
    }

    private int getY(double y) {
        return this.getHeight() - 40 - (int)((double)(this.getHeight() - 80) / (double)this.tiles.length * y);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        int lastY = 0;
        int xOffset = 0;
        int i = 0;
        while (i < this.tiles.length) {
            String label = "" + this.tiles[i];
            int width = g.getFontMetrics().stringWidth(label);
            if (width > xOffset) {
                xOffset = width;
            }
            int thisY = this.getY(i);
            if (i <= 0 || thisY + g.getFontMetrics().getAscent() <= lastY) {
                g.drawString(label, 2, this.getY(i));
                lastY = thisY;
            }
            ++i;
        }
        String graphTitle = "Quality per tile";
        int titleWidth = g.getFontMetrics().stringWidth(graphTitle);
        g.drawString(graphTitle, (xOffset += 5) + (this.getWidth() - (xOffset + 10)) / 2 - titleWidth / 2, 30);
        g.drawLine(xOffset, this.getHeight() - 40, this.getWidth() - 10, this.getHeight() - 40);
        g.drawLine(xOffset, this.getHeight() - 40, xOffset, 40);
        String xLabel = "Position in read (bp)";
        g.drawString(xLabel, this.getWidth() / 2 - g.getFontMetrics().stringWidth(xLabel) / 2, this.getHeight() - 5);
        int baseWidth = (this.getWidth() - (xOffset + 10)) / this.xLabels.length;
        if (baseWidth < 1) {
            baseWidth = 1;
        }
        int lastXLabelEnd = 0;
        g.setColor(Color.BLACK);
        int base = 0;
        while (base < this.xLabels.length) {
            String baseNumber = this.xLabels[base];
            int baseNumberWidth = g.getFontMetrics().stringWidth(baseNumber);
            int baseNumberPosition = baseWidth / 2 + xOffset + baseWidth * base - baseNumberWidth / 2;
            if (baseNumberPosition > lastXLabelEnd) {
                g.drawString(baseNumber, baseNumberPosition, this.getHeight() - 25);
                lastXLabelEnd = baseNumberPosition + baseNumberWidth + 5;
            }
            ++base;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int tile = 0;
        while (tile < this.tiles.length) {
            int base2 = 0;
            while (base2 < this.xLabels.length) {
                g.setColor(this.getColour(tile, base2));
                int x = xOffset + baseWidth * base2;
                int y = this.getY(tile + 1);
                g.fillRect(x, y, baseWidth, this.getY(tile) - this.getY(tile + 1));
                ++base2;
            }
            ++tile;
        }
    }

    private Color getColour(int tile, int base) {
        return this.gradient.getColor(0.0 - this.tileBaseMeans[tile][base], 0.0, ModuleConfig.getParam("tile", "error"));
    }
}

