/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Help;

import java.awt.Frame;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import uk.ac.babraham.FastQC.Help.HelpIndexRoot;
import uk.ac.babraham.FastQC.Help.HelpPage;
import uk.ac.babraham.FastQC.Help.HelpPageDisplay;
import uk.ac.babraham.FastQC.Help.HelpSearchPanel;

public class HelpDialog
extends JDialog
implements TreeSelectionListener {
    private JTree tree;
    private HelpPageDisplay currentPage = null;
    private JSplitPane mainSplit;

    public HelpDialog(JFrame parent, File startingLocation) {
        super((Frame)parent, "Help Contents");
        HelpIndexRoot root = new HelpIndexRoot(startingLocation);
        this.mainSplit = new JSplitPane(1);
        this.setContentPane(this.mainSplit);
        this.tree = new JTree(new DefaultTreeModel(root));
        JSplitPane leftSplit = new JSplitPane(0);
        leftSplit.setTopComponent(new JScrollPane(this.tree));
        leftSplit.setBottomComponent(new HelpSearchPanel(root, this));
        this.mainSplit.setLeftComponent(leftSplit);
        this.currentPage = new HelpPageDisplay(null);
        this.mainSplit.setRightComponent(this.currentPage);
        this.tree.addTreeSelectionListener(this);
        this.setSize(800, 500);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
        leftSplit.setDividerLocation(0.7);
        this.mainSplit.setDividerLocation(0.3);
        this.findStartingPage();
    }

    private void findStartingPage() {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        this.DisplayPage((HelpPage)currentNode.getFirstLeaf());
    }

    public void DisplayPage(HelpPage page) {
        if (this.currentPage != null) {
            int d = this.mainSplit.getDividerLocation();
            this.mainSplit.remove(this.currentPage);
            this.currentPage = new HelpPageDisplay(page);
            this.mainSplit.setRightComponent(this.currentPage);
            this.mainSplit.setDividerLocation(d);
        }
    }

    public void valueChanged(TreeSelectionEvent tse) {
        if (tse.getNewLeadSelectionPath() == null) {
            return;
        }
        Object o = tse.getNewLeadSelectionPath().getLastPathComponent();
        if (o instanceof HelpPage && ((HelpPage)o).isLeaf()) {
            this.DisplayPage((HelpPage)o);
        }
    }
}

