/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Utilities.ImageToBase64;

public abstract class AbstractQCModule
implements QCModule {
    protected void simpleXhtmlReport(HTMLReportArchive report, BufferedImage img, String alt) throws XMLStreamException {
        XMLStreamWriter xhtml = report.xhtmlStream();
        xhtml.writeStartElement("p");
        xhtml.writeEmptyElement("img");
        xhtml.writeAttribute("class", "indented");
        xhtml.writeAttribute("src", ImageToBase64.imageToBase64(img));
        xhtml.writeAttribute("alt", alt);
        if (img != null) {
            xhtml.writeAttribute("width", String.valueOf(img.getWidth()));
            xhtml.writeAttribute("height", String.valueOf(img.getHeight()));
        }
        xhtml.writeEndElement();
    }

    protected void writeDefaultImage(HTMLReportArchive report, String fileName, String imageTitle, int width, int height) throws IOException, XMLStreamException {
        ZipOutputStream zip = report.zipFile();
        zip.putNextEntry(new ZipEntry(String.valueOf(report.folderName()) + "/Images/" + fileName));
        BufferedImage b = new BufferedImage(width, height, 1);
        Graphics2D g = b.createGraphics();
        JPanel resultsPanel = this.getResultsPanel();
        resultsPanel.setDoubleBuffered(false);
        resultsPanel.setSize(width, height);
        resultsPanel.addNotify();
        resultsPanel.validate();
        resultsPanel.print(g);
        g.dispose();
        ImageIO.write((RenderedImage)b, "PNG", zip);
        zip.closeEntry();
        this.simpleXhtmlReport(report, b, imageTitle);
    }

    protected void writeSpecificImage(HTMLReportArchive report, JPanel resultsPanel, String fileName, String imageTitle, int width, int height) throws IOException, XMLStreamException {
        ZipOutputStream zip = report.zipFile();
        zip.putNextEntry(new ZipEntry(String.valueOf(report.folderName()) + "/Images/" + fileName));
        BufferedImage b = new BufferedImage(width, height, 1);
        Graphics2D g = b.createGraphics();
        resultsPanel.setDoubleBuffered(false);
        resultsPanel.setSize(width, height);
        resultsPanel.addNotify();
        resultsPanel.validate();
        resultsPanel.print(g);
        g.dispose();
        ImageIO.write((RenderedImage)b, "PNG", zip);
        zip.closeEntry();
        this.simpleXhtmlReport(report, b, imageTitle);
    }

    protected void writeTable(HTMLReportArchive report, TableModel table) throws IOException, XMLStreamException {
        this.writeXhtmlTable(report, table);
        this.writeTextTable(report, table);
    }

    protected void writeXhtmlTable(HTMLReportArchive report, TableModel table) throws IOException, XMLStreamException {
        XMLStreamWriter w = report.xhtmlStream();
        w.writeStartElement("table");
        w.writeStartElement("thead");
        w.writeStartElement("tr");
        int c = 0;
        while (c < table.getColumnCount()) {
            w.writeStartElement("th");
            w.writeCharacters(table.getColumnName(c));
            w.writeEndElement();
            ++c;
        }
        w.writeEndElement();
        w.writeEndElement();
        w.writeStartElement("tbody");
        int r = 0;
        while (r < table.getRowCount()) {
            w.writeStartElement("tr");
            int c2 = 0;
            while (c2 < table.getColumnCount()) {
                w.writeStartElement("td");
                w.writeCharacters(String.valueOf(table.getValueAt(r, c2)));
                w.writeEndElement();
                ++c2;
            }
            w.writeEndElement();
            ++r;
        }
        w.writeEndElement();
        w.writeEndElement();
    }

    protected void writeTextTable(HTMLReportArchive report, TableModel table) throws IOException {
        StringBuffer d = report.dataDocument();
        d.append("#");
        int c = 0;
        while (c < table.getColumnCount()) {
            if (c != 0) {
                d.append("\t");
            }
            d.append(table.getColumnName(c));
            ++c;
        }
        d.append("\n");
        int r = 0;
        while (r < table.getRowCount()) {
            int c2 = 0;
            while (c2 < table.getColumnCount()) {
                if (c2 != 0) {
                    d.append("\t");
                }
                d.append(table.getValueAt(r, c2));
                ++c2;
            }
            d.append("\n");
            ++r;
        }
    }
}

