/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Graphs.BaseGroup;
import uk.ac.babraham.FastQC.Graphs.LineGraph;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Contaminant.ContaminentFinder;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class AdapterContent
extends AbstractQCModule {
    private int longestSequence = 0;
    private int longestAdapter = 0;
    private long totalCount = 0L;
    public boolean calculated = false;
    private Adapter[] adapters;
    private double[][] enrichments = null;
    private String[] labels;
    private String[] xLabels = new String[0];
    BaseGroup[] groups;

    public AdapterContent() {
        Vector<Adapter> c = new Vector<Adapter>();
        Vector<String> l = new Vector<String>();
        try {
            String line;
            BufferedReader br = null;
            if (FastQCConfig.getInstance().adapter_file == null) {
                InputStream rsrc = ContaminentFinder.class.getResourceAsStream("/Configuration/adapter_list.txt");
                if (rsrc == null) {
                    throw new FileNotFoundException("cannot find Configuration/adapter_list.txt");
                }
                br = new BufferedReader(new InputStreamReader(rsrc));
            } else {
                br = new BufferedReader(new FileReader(FastQCConfig.getInstance().adapter_file));
            }
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                String[] sections = line.split("\\t+");
                if (sections.length != 2) {
                    System.err.println("Expected 2 sections for contaminant line but got " + sections.length + " from " + line);
                    continue;
                }
                Adapter adapter = new Adapter(sections[0], sections[1]);
                c.add(adapter);
                l.add(adapter.name());
                if (adapter.sequence().length() <= this.longestAdapter) continue;
                this.longestAdapter = adapter.sequence().length();
            }
            this.labels = l.toArray(new String[0]);
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.adapters = c.toArray(new Adapter[0]);
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("adapter", "ignore") > 0.0;
    }

    public JPanel getResultsPanel() {
        if (this.longestAdapter > this.longestSequence) {
            JPanel failPanel = new JPanel();
            failPanel.setLayout(new BorderLayout());
            failPanel.add((Component)new JLabel("Can't analyse adapters as read length is too short (" + this.longestAdapter + " vs " + this.longestSequence + ")", 0), "Center");
            return failPanel;
        }
        if (!this.calculated) {
            this.calculateEnrichment();
        }
        return new LineGraph(this.enrichments, 0.0, 100.0, "Position in read (bp)", this.labels, this.xLabels, "% Adapter");
    }

    public void processSequence(Sequence sequence) {
        int a;
        this.calculated = false;
        ++this.totalCount;
        if (sequence.getSequence().length() > this.longestSequence && sequence.getSequence().length() - this.longestAdapter > 0) {
            this.longestSequence = sequence.getSequence().length();
            a = 0;
            while (a < this.adapters.length) {
                this.adapters[a].expandLengthTo(this.longestSequence - this.longestAdapter + 1);
                ++a;
            }
        }
        a = 0;
        while (a < this.adapters.length) {
            int index = sequence.getSequence().indexOf(this.adapters[a].sequence());
            if (index >= 0) {
                int i = index;
                while (i <= this.longestSequence - this.longestAdapter) {
                    this.adapters[a].incrementCount(i);
                    ++i;
                }
            }
            ++a;
        }
    }

    public synchronized void calculateEnrichment() {
        int maxLength = 0;
        int a = 0;
        while (a < this.adapters.length) {
            if (this.adapters[a].getPositions().length > maxLength) {
                maxLength = this.adapters[a].getPositions().length;
            }
            ++a;
        }
        this.groups = BaseGroup.makeBaseGroups(maxLength);
        this.xLabels = new String[this.groups.length];
        int i = 0;
        while (i < this.xLabels.length) {
            this.xLabels[i] = this.groups[i].toString();
            ++i;
        }
        this.enrichments = new double[this.adapters.length][this.groups.length];
        a = 0;
        while (a < this.adapters.length) {
            long[] positions = this.adapters[a].positions;
            int g = 0;
            while (g < this.groups.length) {
                int p = this.groups[g].lowerCount() - 1;
                while (p < this.groups[g].upperCount() && p < positions.length) {
                    double[] dArray = this.enrichments[a];
                    int n = g;
                    dArray[n] = dArray[n] + (double)positions[p] * 100.0 / (double)this.totalCount;
                    ++p;
                }
                double[] dArray = this.enrichments[a];
                int n = g;
                dArray[n] = dArray[n] / (double)(this.groups[g].upperCount() - this.groups[g].lowerCount() + 1);
                ++g;
            }
            ++a;
        }
        this.calculated = true;
    }

    public void reset() {
        this.calculated = false;
        this.totalCount = 0L;
        this.longestSequence = 0;
        int a = 0;
        while (a < this.adapters.length) {
            this.adapters[a].reset();
            ++a;
        }
    }

    public String description() {
        return "Searches for specific adapter sequences in a library";
    }

    public String name() {
        return "Adapter Content";
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.calculateEnrichment();
        }
        int i = 0;
        while (i < this.enrichments.length) {
            int j = 0;
            while (j < this.enrichments[i].length) {
                if (this.enrichments[i][j] > ModuleConfig.getParam("adapter", "error")) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean raisesWarning() {
        if (this.longestAdapter > this.longestSequence) {
            return true;
        }
        if (!this.calculated) {
            this.calculateEnrichment();
        }
        int i = 0;
        while (i < this.enrichments.length) {
            int j = 0;
            while (j < this.enrichments[i].length) {
                if (this.enrichments[i][j] > ModuleConfig.getParam("adapter", "warn")) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        if (this.longestAdapter > this.longestSequence) {
            XMLStreamWriter xhtml = report.xhtmlStream();
            xhtml.writeStartElement("p");
            xhtml.writeCharacters("Can't analyse adapters as read length is too short (" + this.longestAdapter + " vs " + this.longestSequence + ")");
            xhtml.writeEndElement();
        } else {
            if (!this.calculated) {
                this.calculateEnrichment();
            }
            this.writeDefaultImage(report, "adapter_content.png", "Adapter graph", Math.max(800, this.groups.length * 15), 600);
            StringBuffer sb = report.dataDocument();
            ResultsTable table = new ResultsTable();
            sb.append("#");
            int i = 0;
            while (i < table.getColumnCount()) {
                if (i > 0) {
                    sb.append("\t");
                }
                sb.append(table.getColumnName(i));
                ++i;
            }
            sb.append("\n");
            int r = 0;
            while (r < table.getRowCount()) {
                int c = 0;
                while (c < table.getColumnCount()) {
                    if (c > 0) {
                        sb.append("\t");
                    }
                    sb.append(table.getValueAt(r, c));
                    ++c;
                }
                sb.append("\n");
                ++r;
            }
        }
    }

    private class Adapter {
        private String name;
        private String sequence;
        private long[] positions = new long[0];

        public Adapter(String name, String sequence) {
            this.name = name;
            this.sequence = sequence;
            this.positions = new long[1];
        }

        public void incrementCount(int position) {
            int n = position;
            this.positions[n] = this.positions[n] + 1L;
        }

        public void expandLengthTo(int newLength) {
            long[] newPositions = new long[newLength];
            int i = 0;
            while (i < this.positions.length) {
                newPositions[i] = this.positions[i];
                ++i;
            }
            if (this.positions.length > 0) {
                i = this.positions.length;
                while (i < newPositions.length) {
                    newPositions[i] = this.positions[this.positions.length - 1];
                    ++i;
                }
            }
            this.positions = newPositions;
        }

        public long[] getPositions() {
            return this.positions;
        }

        public String sequence() {
            return this.sequence;
        }

        public void reset() {
            this.positions = new long[0];
        }

        public String name() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultsTable
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return AdapterContent.this.adapters.length + 1;
        }

        @Override
        public int getRowCount() {
            return AdapterContent.this.enrichments[0].length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return AdapterContent.this.xLabels[rowIndex];
            }
            return AdapterContent.this.enrichments[columnIndex - 1][rowIndex];
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Position";
            }
            return AdapterContent.this.labels[columnIndex - 1];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
            }
            return Double.class;
        }
    }
}

