/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.DuplicationLevel;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Contaminant.ContaminantHit;
import uk.ac.babraham.FastQC.Sequence.Contaminant.ContaminentFinder;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class OverRepresentedSeqs
extends AbstractQCModule {
    protected HashMap<String, Integer> sequences = new HashMap();
    protected long count = 0L;
    private OverrepresentedSeq[] overrepresntedSeqs = null;
    private boolean calculated = false;
    private boolean frozen = false;
    private DuplicationLevel duplicationModule = new DuplicationLevel(this);
    private final int OBSERVATION_CUTOFF = 100000;
    private int uniqueSequenceCount = 0;
    protected long countAtUniqueLimit = 0L;

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("overrepresented", "ignore") > 0.0;
    }

    public String description() {
        return "Identifies sequences which are overrepresented in the set";
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }

    public DuplicationLevel duplicationLevelModule() {
        return this.duplicationModule;
    }

    public JPanel getResultsPanel() {
        JPanel returnPanel = new JPanel();
        returnPanel.setLayout(new BorderLayout());
        returnPanel.add((Component)new JLabel("Overrepresented sequences", 0), "North");
        if (!this.calculated) {
            this.getOverrepresentedSeqs();
        }
        if (this.overrepresntedSeqs.length > 0) {
            ResultsTable model = new ResultsTable(this.overrepresntedSeqs);
            JTable table = new JTable(model);
            table.setCellSelectionEnabled(true);
            returnPanel.add((Component)new JScrollPane(table), "Center");
        } else {
            returnPanel.add((Component)new JLabel("There are no overrepresented sequences", 0), "Center");
        }
        return returnPanel;
    }

    public DuplicationLevel getDuplicationLevelModule() {
        return this.duplicationModule;
    }

    private synchronized void getOverrepresentedSeqs() {
        this.duplicationModule.calculateLevels();
        Iterator<String> s = this.sequences.keySet().iterator();
        ArrayList<OverrepresentedSeq> keepers = new ArrayList<OverrepresentedSeq>();
        while (s.hasNext()) {
            String seq = s.next();
            double percentage = (double)this.sequences.get(seq).intValue() / (double)this.count * 100.0;
            if (!(percentage > ModuleConfig.getParam("overrepresented", "warn"))) continue;
            OverrepresentedSeq os = new OverrepresentedSeq(seq, this.sequences.get(seq), percentage);
            keepers.add(os);
        }
        this.overrepresntedSeqs = keepers.toArray(new OverrepresentedSeq[0]);
        Arrays.sort(this.overrepresntedSeqs);
        this.calculated = true;
        this.sequences.clear();
    }

    public void reset() {
        this.count = 0L;
        this.sequences.clear();
    }

    public String name() {
        return "Overrepresented sequences";
    }

    public void processSequence(Sequence sequence) {
        this.calculated = false;
        ++this.count;
        String seq = sequence.getSequence();
        if (seq.length() > 75) {
            seq = new String(seq.substring(0, 50));
        }
        if (this.sequences.containsKey(seq)) {
            this.sequences.put(seq, this.sequences.get(seq) + 1);
            if (!this.frozen) {
                this.countAtUniqueLimit = this.count;
            }
        } else if (!this.frozen) {
            this.sequences.put(seq, 1);
            ++this.uniqueSequenceCount;
            this.countAtUniqueLimit = this.count;
            if (this.uniqueSequenceCount == 100000) {
                this.frozen = true;
            }
        }
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.getOverrepresentedSeqs();
        }
        return this.overrepresntedSeqs.length > 0 && this.overrepresntedSeqs[0].percentage > ModuleConfig.getParam("overrepresented", "error");
    }

    public boolean raisesWarning() {
        if (!this.calculated) {
            this.getOverrepresentedSeqs();
        }
        return this.overrepresntedSeqs.length > 0;
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        if (!this.calculated) {
            this.getOverrepresentedSeqs();
        }
        ResultsTable table = new ResultsTable(this.overrepresntedSeqs);
        if (this.overrepresntedSeqs.length == 0) {
            XMLStreamWriter w = report.xhtmlStream();
            w.writeStartElement("p");
            w.writeCharacters("No overrepresented sequences");
            w.writeEndElement();
        } else {
            super.writeTable(report, table);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrepresentedSeq
    implements Comparable<OverrepresentedSeq> {
        private String seq;
        private int count;
        private double percentage;
        private ContaminantHit contaminantHit;

        public OverrepresentedSeq(String seq, int count, double percentage) {
            this.seq = seq;
            this.count = count;
            this.percentage = percentage;
            this.contaminantHit = ContaminentFinder.findContaminantHit(seq);
        }

        public String seq() {
            return this.seq;
        }

        public int count() {
            return this.count;
        }

        public double percentage() {
            return this.percentage;
        }

        public String contaminantHit() {
            if (this.contaminantHit == null) {
                return "No Hit";
            }
            return this.contaminantHit.toString();
        }

        @Override
        public int compareTo(OverrepresentedSeq o) {
            return o.count - this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultsTable
    extends AbstractTableModel {
        private OverrepresentedSeq[] seqs;

        public ResultsTable(OverrepresentedSeq[] seqs) {
            this.seqs = seqs;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.seqs.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.seqs[rowIndex].seq();
                }
                case 1: {
                    return this.seqs[rowIndex].count();
                }
                case 2: {
                    return this.seqs[rowIndex].percentage();
                }
                case 3: {
                    return this.seqs[rowIndex].contaminantHit();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Sequence";
                }
                case 1: {
                    return "Count";
                }
                case 2: {
                    return "Percentage";
                }
                case 3: {
                    return "Possible Source";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Double.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return null;
        }
    }
}

