/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.io.IOException;
import javax.swing.JPanel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Graphs.BaseGroup;
import uk.ac.babraham.FastQC.Graphs.QualityBoxPlot;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.QualityEncoding.PhredEncoding;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Utilities.QualityCount;

public class PerBaseQualityScores
extends AbstractQCModule {
    public QualityCount[] qualityCounts = new QualityCount[0];
    double[] means = null;
    double[] medians = null;
    double[] lowerQuartile = null;
    double[] upperQuartile = null;
    double[] lowest = null;
    double[] highest = null;
    String[] xLabels;
    int low = 0;
    int high = 0;
    PhredEncoding encodingScheme;
    private boolean calculated = false;

    public JPanel getResultsPanel() {
        if (!this.calculated) {
            this.getPercentages();
        }
        return new QualityBoxPlot(this.means, this.medians, this.lowest, this.highest, this.lowerQuartile, this.upperQuartile, this.low, this.high, 2.0, this.xLabels, "Quality scores across all bases (" + this.encodingScheme + " encoding)");
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("quality_base", "ignore") > 0.0 || this.qualityCounts.length == 0;
    }

    private synchronized void getPercentages() {
        char[] range = this.calculateOffsets();
        this.encodingScheme = PhredEncoding.getFastQEncodingOffset(range[0]);
        this.low = 0;
        this.high = range[1] - this.encodingScheme.offset();
        if (this.high < 35) {
            this.high = 35;
        }
        BaseGroup[] groups = BaseGroup.makeBaseGroups(this.qualityCounts.length);
        this.means = new double[groups.length];
        this.medians = new double[groups.length];
        this.lowest = new double[groups.length];
        this.highest = new double[groups.length];
        this.lowerQuartile = new double[groups.length];
        this.upperQuartile = new double[groups.length];
        this.xLabels = new String[groups.length];
        int i = 0;
        while (i < groups.length) {
            this.xLabels[i] = groups[i].toString();
            int minBase = groups[i].lowerCount();
            int maxBase = groups[i].upperCount();
            this.lowest[i] = this.getPercentile(minBase, maxBase, this.encodingScheme.offset(), 10);
            this.highest[i] = this.getPercentile(minBase, maxBase, this.encodingScheme.offset(), 90);
            this.means[i] = this.getMean(minBase, maxBase, this.encodingScheme.offset());
            this.medians[i] = this.getPercentile(minBase, maxBase, this.encodingScheme.offset(), 50);
            this.lowerQuartile[i] = this.getPercentile(minBase, maxBase, this.encodingScheme.offset(), 25);
            this.upperQuartile[i] = this.getPercentile(minBase, maxBase, this.encodingScheme.offset(), 75);
            ++i;
        }
        this.calculated = true;
    }

    private char[] calculateOffsets() {
        char minChar = '\u0000';
        char maxChar = '\u0000';
        int q = 0;
        while (q < this.qualityCounts.length) {
            if (q == 0) {
                minChar = this.qualityCounts[q].getMinChar();
                maxChar = this.qualityCounts[q].getMaxChar();
            } else {
                if (this.qualityCounts[q].getMinChar() < minChar) {
                    minChar = this.qualityCounts[q].getMinChar();
                }
                if (this.qualityCounts[q].getMaxChar() > maxChar) {
                    maxChar = this.qualityCounts[q].getMaxChar();
                }
            }
            ++q;
        }
        return new char[]{minChar, maxChar};
    }

    public void processSequence(Sequence sequence) {
        this.calculated = false;
        char[] qual = sequence.getQualityString().toCharArray();
        if (this.qualityCounts.length < qual.length) {
            QualityCount[] qualityCountsNew = new QualityCount[qual.length];
            int i = 0;
            while (i < this.qualityCounts.length) {
                qualityCountsNew[i] = this.qualityCounts[i];
                ++i;
            }
            i = this.qualityCounts.length;
            while (i < qualityCountsNew.length) {
                qualityCountsNew[i] = new QualityCount();
                ++i;
            }
            this.qualityCounts = qualityCountsNew;
        }
        int i = 0;
        while (i < qual.length) {
            this.qualityCounts[i].addValue(qual[i]);
            ++i;
        }
    }

    public void reset() {
        this.qualityCounts = new QualityCount[0];
    }

    public String description() {
        return "Shows the Quality scores of all bases at a given position in a sequencing run";
    }

    public String name() {
        return "Per base sequence quality";
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.getPercentages();
        }
        int i = 0;
        while (i < this.lowerQuartile.length) {
            if (!Double.isNaN(this.lowerQuartile[i]) && (this.lowerQuartile[i] < ModuleConfig.getParam("quality_base_lower", "error") || this.medians[i] < ModuleConfig.getParam("quality_base_median", "error"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean raisesWarning() {
        if (!this.calculated) {
            this.getPercentages();
        }
        int i = 0;
        while (i < this.lowerQuartile.length) {
            if (!Double.isNaN(this.lowerQuartile[i]) && (this.lowerQuartile[i] < ModuleConfig.getParam("quality_base_lower", "warn") || this.medians[i] < ModuleConfig.getParam("quality_base_median", "warn"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        if (!this.calculated) {
            this.getPercentages();
        }
        this.writeDefaultImage(report, "per_base_quality.png", "Per base quality graph", Math.max(800, this.means.length * 15), 600);
        StringBuffer sb = report.dataDocument();
        sb.append("#Base\tMean\tMedian\tLower Quartile\tUpper Quartile\t10th Percentile\t90th Percentile\n");
        int i = 0;
        while (i < this.means.length) {
            sb.append(this.xLabels[i]);
            sb.append("\t");
            sb.append(this.means[i]);
            sb.append("\t");
            sb.append(this.medians[i]);
            sb.append("\t");
            sb.append(this.lowerQuartile[i]);
            sb.append("\t");
            sb.append(this.upperQuartile[i]);
            sb.append("\t");
            sb.append(this.lowest[i]);
            sb.append("\t");
            sb.append(this.highest[i]);
            sb.append("\n");
            ++i;
        }
    }

    private double getPercentile(int minbp, int maxbp, int offset, int percentile) {
        int count = 0;
        double total = 0.0;
        int i = minbp - 1;
        while (i < maxbp) {
            if (this.qualityCounts[i].getTotalCount() > 100L) {
                ++count;
                total += this.qualityCounts[i].getPercentile(offset, percentile);
            }
            ++i;
        }
        if (count > 0) {
            return total / (double)count;
        }
        return Double.NaN;
    }

    private double getMean(int minbp, int maxbp, int offset) {
        int count = 0;
        double total = 0.0;
        int i = minbp - 1;
        while (i < maxbp) {
            if (this.qualityCounts[i].getTotalCount() > 0L) {
                ++count;
                total += this.qualityCounts[i].getMean(offset);
            }
            ++i;
        }
        if (count > 0) {
            return total / (double)count;
        }
        return 0.0;
    }
}

