/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.io.IOException;
import javax.swing.JPanel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Graphs.BaseGroup;
import uk.ac.babraham.FastQC.Graphs.LineGraph;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class PerBaseSequenceContent
extends AbstractQCModule {
    public long[] gCounts = new long[0];
    public long[] aCounts = new long[0];
    public long[] cCounts = new long[0];
    public long[] tCounts = new long[0];
    private double[][] percentages = null;
    private String[] xCategories = new String[0];
    private boolean calculated = false;

    public JPanel getResultsPanel() {
        if (!this.calculated) {
            this.getPercentages();
        }
        return new LineGraph(this.percentages, 0.0, 100.0, "Position in read (bp)", new String[]{"%T", "%C", "%A", "%G"}, this.xCategories, "Sequence content across all bases");
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("sequence", "ignore") > 0.0;
    }

    private synchronized void getPercentages() {
        BaseGroup[] groups = BaseGroup.makeBaseGroups(this.gCounts.length);
        this.xCategories = new String[groups.length];
        double[] gPercent = new double[groups.length];
        double[] aPercent = new double[groups.length];
        double[] tPercent = new double[groups.length];
        double[] cPercent = new double[groups.length];
        int i = 0;
        while (i < groups.length) {
            this.xCategories[i] = groups[i].toString();
            long gCount = 0L;
            long aCount = 0L;
            long tCount = 0L;
            long cCount = 0L;
            long total = 0L;
            int bp = groups[i].lowerCount() - 1;
            while (bp < groups[i].upperCount()) {
                total += this.gCounts[bp];
                total += this.cCounts[bp];
                total += this.aCounts[bp];
                total += this.tCounts[bp];
                aCount += this.aCounts[bp];
                tCount += this.tCounts[bp];
                cCount += this.cCounts[bp];
                gCount += this.gCounts[bp];
                ++bp;
            }
            gPercent[i] = (double)gCount / (double)total * 100.0;
            aPercent[i] = (double)aCount / (double)total * 100.0;
            tPercent[i] = (double)tCount / (double)total * 100.0;
            cPercent[i] = (double)cCount / (double)total * 100.0;
            ++i;
        }
        this.percentages = new double[][]{tPercent, cPercent, aPercent, gPercent};
        this.calculated = true;
    }

    public void processSequence(Sequence sequence) {
        this.calculated = false;
        char[] seq = sequence.getSequence().toCharArray();
        if (this.gCounts.length < seq.length) {
            long[] gCountsNew = new long[seq.length];
            long[] aCountsNew = new long[seq.length];
            long[] cCountsNew = new long[seq.length];
            long[] tCountsNew = new long[seq.length];
            int i = 0;
            while (i < this.gCounts.length) {
                gCountsNew[i] = this.gCounts[i];
                aCountsNew[i] = this.aCounts[i];
                tCountsNew[i] = this.tCounts[i];
                cCountsNew[i] = this.cCounts[i];
                ++i;
            }
            this.gCounts = gCountsNew;
            this.aCounts = aCountsNew;
            this.tCounts = tCountsNew;
            this.cCounts = cCountsNew;
        }
        int i = 0;
        while (i < seq.length) {
            if (seq[i] == 'G') {
                int n = i;
                this.gCounts[n] = this.gCounts[n] + 1L;
            } else if (seq[i] == 'A') {
                int n = i;
                this.aCounts[n] = this.aCounts[n] + 1L;
            } else if (seq[i] == 'T') {
                int n = i;
                this.tCounts[n] = this.tCounts[n] + 1L;
            } else if (seq[i] == 'C') {
                int n = i;
                this.cCounts[n] = this.cCounts[n] + 1L;
            }
            ++i;
        }
    }

    public void reset() {
        this.gCounts = new long[0];
        this.aCounts = new long[0];
        this.tCounts = new long[0];
        this.cCounts = new long[0];
    }

    public String description() {
        return "Shows the relative amounts of each base at each position in a sequencing run";
    }

    public String name() {
        return "Per base sequence content";
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.getPercentages();
        }
        int i = 0;
        while (i < this.percentages[0].length) {
            double gcDiff = Math.abs(this.percentages[1][i] - this.percentages[3][i]);
            double atDiff = Math.abs(this.percentages[0][i] - this.percentages[2][i]);
            if (gcDiff > ModuleConfig.getParam("sequence", "error") || atDiff > ModuleConfig.getParam("sequence", "error")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean raisesWarning() {
        if (!this.calculated) {
            this.getPercentages();
        }
        int i = 0;
        while (i < this.percentages[0].length) {
            double gcDiff = Math.abs(this.percentages[1][i] - this.percentages[3][i]);
            double atDiff = Math.abs(this.percentages[0][i] - this.percentages[2][i]);
            if (gcDiff > ModuleConfig.getParam("sequence", "warn") || atDiff > ModuleConfig.getParam("sequence", "warn")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        if (!this.calculated) {
            this.getPercentages();
        }
        this.writeDefaultImage(report, "per_base_sequence_content.png", "Per base sequence content", Math.max(800, this.xCategories.length * 15), 600);
        StringBuffer sb = report.dataDocument();
        sb.append("#Base\tG\tA\tT\tC\n");
        int i = 0;
        while (i < this.xCategories.length) {
            sb.append(this.xCategories[i]);
            sb.append("\t");
            sb.append(this.percentages[3][i]);
            sb.append("\t");
            sb.append(this.percentages[2][i]);
            sb.append("\t");
            sb.append(this.percentages[0][i]);
            sb.append("\t");
            sb.append(this.percentages[1][i]);
            sb.append("\n");
            ++i;
        }
    }
}

