/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.io.IOException;
import javax.swing.JPanel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Graphs.LineGraph;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.GCModel.GCModel;
import uk.ac.babraham.FastQC.Modules.GCModel.GCModelValue;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Statistics.NormalDistribution;

public class PerSequenceGCContent
extends AbstractQCModule {
    private double[] gcDistribution = new double[101];
    private double[] theoreticalDistribution = new double[101];
    private int[] xCategories = new int[0];
    private double max = 0.0;
    private double deviationPercent;
    private boolean calculated = false;
    private GCModel[] cachedModels = new GCModel[200];

    public JPanel getResultsPanel() {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        return new LineGraph((double[][])new double[][]{this.gcDistribution, this.theoreticalDistribution}, 0.0, this.max, "Mean GC content (%)", new String[]{"GC count per read", "Theoretical Distribution"}, this.xCategories, "GC distribution over all sequences");
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("gc_sequence", "ignore") > 0.0;
    }

    private synchronized void calculateDistribution() {
        this.max = 0.0;
        this.xCategories = new int[this.gcDistribution.length];
        double totalCount = 0.0;
        int firstMode = 0;
        double modeCount = 0.0;
        int i = 0;
        while (i < this.gcDistribution.length) {
            this.xCategories[i] = i;
            totalCount += this.gcDistribution[i];
            if (this.gcDistribution[i] > modeCount) {
                modeCount = this.gcDistribution[i];
                firstMode = i;
            }
            if (this.gcDistribution[i] > this.max) {
                this.max = this.gcDistribution[i];
            }
            ++i;
        }
        double mode = 0.0;
        int modeDuplicates = 0;
        boolean fellOffTop = true;
        int i2 = firstMode;
        while (i2 < this.gcDistribution.length) {
            if (this.gcDistribution[i2] > this.gcDistribution[firstMode] - this.gcDistribution[firstMode] / 10.0) {
                mode += (double)i2;
                ++modeDuplicates;
            } else {
                fellOffTop = false;
                break;
            }
            ++i2;
        }
        boolean fellOffBottom = true;
        int i3 = firstMode - 1;
        while (i3 >= 0) {
            if (this.gcDistribution[i3] > this.gcDistribution[firstMode] - this.gcDistribution[firstMode] / 10.0) {
                mode += (double)i3;
                ++modeDuplicates;
            } else {
                fellOffBottom = false;
                break;
            }
            --i3;
        }
        mode = fellOffBottom || fellOffTop ? (double)firstMode : (mode /= (double)modeDuplicates);
        double stdev = 0.0;
        int i4 = 0;
        while (i4 < this.gcDistribution.length) {
            stdev += Math.pow((double)i4 - mode, 2.0) * this.gcDistribution[i4];
            ++i4;
        }
        stdev /= totalCount - 1.0;
        stdev = Math.sqrt(stdev);
        NormalDistribution nd = new NormalDistribution(mode, stdev);
        this.deviationPercent = 0.0;
        int i5 = 0;
        while (i5 < this.theoreticalDistribution.length) {
            double probability = nd.getZScoreForValue(i5);
            this.theoreticalDistribution[i5] = probability * totalCount;
            if (this.theoreticalDistribution[i5] > this.max) {
                this.max = this.theoreticalDistribution[i5];
            }
            this.deviationPercent += Math.abs(this.theoreticalDistribution[i5] - this.gcDistribution[i5]);
            ++i5;
        }
        this.deviationPercent /= totalCount;
        this.deviationPercent *= 100.0;
        this.calculated = true;
    }

    public void processSequence(Sequence sequence) {
        int i;
        char[] seq = this.truncateSequence(sequence);
        if (seq.length == 0) {
            return;
        }
        int thisSeqGCCount = 0;
        int i2 = 0;
        while (i2 < seq.length) {
            if (seq[i2] == 'G' || seq[i2] == 'C') {
                ++thisSeqGCCount;
            }
            ++i2;
        }
        if (seq.length >= this.cachedModels.length) {
            GCModel[] longerModels = new GCModel[seq.length + 1];
            i = 0;
            while (i < this.cachedModels.length) {
                longerModels[i] = this.cachedModels[i];
                ++i;
            }
            this.cachedModels = longerModels;
        }
        if (this.cachedModels[seq.length] == null) {
            this.cachedModels[seq.length] = new GCModel(seq.length);
        }
        GCModelValue[] values = this.cachedModels[seq.length].getModelValues(thisSeqGCCount);
        i = 0;
        while (i < values.length) {
            int n = values[i].percentage();
            this.gcDistribution[n] = this.gcDistribution[n] + values[i].increment();
            ++i;
        }
    }

    private char[] truncateSequence(Sequence sequence) {
        String seq = sequence.getSequence();
        if (seq.length() > 1000) {
            int length = seq.length() / 1000 * 1000;
            return seq.substring(0, length).toCharArray();
        }
        if (seq.length() > 100) {
            int length = seq.length() / 100 * 100;
            return seq.substring(0, length).toCharArray();
        }
        return seq.toCharArray();
    }

    public void reset() {
        this.gcDistribution = new double[101];
    }

    public String description() {
        return "Shows the distribution of GC contents for whole sequences";
    }

    public String name() {
        return "Per sequence GC content";
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        return this.deviationPercent > ModuleConfig.getParam("gc_sequence", "error");
    }

    public boolean raisesWarning() {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        return this.deviationPercent > ModuleConfig.getParam("gc_sequence", "warn");
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        this.writeDefaultImage(report, "per_sequence_gc_content.png", "Per sequence GC content graph", 800, 600);
        StringBuffer sb = report.dataDocument();
        sb.append("#GC Content\tCount\n");
        int i = 0;
        while (i < this.xCategories.length) {
            sb.append(this.xCategories[i]);
            sb.append("\t");
            sb.append(this.gcDistribution[i]);
            sb.append("\n");
            ++i;
        }
    }
}

