/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Graphs.LineGraph;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.QualityEncoding.PhredEncoding;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class PerSequenceQualityScores
extends AbstractQCModule {
    private HashMap<Integer, Long> averageScoreCounts = new HashMap();
    private double[] qualityDistribution = null;
    private int[] xCategories = new int[0];
    private char lowestChar = (char)126;
    private int maxCount = 0;
    private int mostFrequentScore;
    private boolean calculated = false;

    public JPanel getResultsPanel() {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        return new LineGraph((double[][])new double[][]{this.qualityDistribution}, 0.0, (double)this.maxCount, "Mean Sequence Quality (Phred Score)", new String[]{"Average Quality per read"}, this.xCategories, "Quality score distribution over all sequences");
    }

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("quality_sequence", "ignore") > 0.0 || this.averageScoreCounts.size() == 0;
    }

    private synchronized void calculateDistribution() {
        PhredEncoding encoding = PhredEncoding.getFastQEncodingOffset(this.lowestChar);
        Object[] rawScores = this.averageScoreCounts.keySet().toArray(new Integer[0]);
        Arrays.sort(rawScores);
        this.qualityDistribution = new double[1 + ((Integer)rawScores[rawScores.length - 1] - (Integer)rawScores[0])];
        this.xCategories = new int[this.qualityDistribution.length];
        int i = 0;
        while (i < this.qualityDistribution.length) {
            this.xCategories[i] = (Integer)rawScores[0] + i - encoding.offset();
            if (this.averageScoreCounts.containsKey((Integer)rawScores[0] + i)) {
                this.qualityDistribution[i] = this.averageScoreCounts.get((Integer)rawScores[0] + i).longValue();
            }
            ++i;
        }
        i = 0;
        while (i < this.qualityDistribution.length) {
            if (this.qualityDistribution[i] > (double)this.maxCount) {
                this.maxCount = (int)this.qualityDistribution[i];
                this.mostFrequentScore = this.xCategories[i];
            }
            ++i;
        }
        this.calculated = true;
    }

    public void processSequence(Sequence sequence) {
        char[] seq = sequence.getQualityString().toCharArray();
        int averageQuality = 0;
        int i = 0;
        while (i < seq.length) {
            if (seq[i] < this.lowestChar) {
                this.lowestChar = seq[i];
            }
            averageQuality += seq[i];
            ++i;
        }
        if (seq.length > 0) {
            if (this.averageScoreCounts.containsKey(averageQuality /= seq.length)) {
                long currentCount = this.averageScoreCounts.get(averageQuality);
                this.averageScoreCounts.put(averageQuality, ++currentCount);
            } else {
                this.averageScoreCounts.put(averageQuality, 1L);
            }
        }
    }

    public void reset() {
        this.averageScoreCounts.clear();
        this.lowestChar = (char)126;
        this.maxCount = 0;
        this.calculated = false;
    }

    public String description() {
        return "Shows the distribution of average quality scores for whole sequences";
    }

    public String name() {
        return "Per sequence quality scores";
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        return (double)this.mostFrequentScore <= ModuleConfig.getParam("quality_sequence", "error");
    }

    public boolean raisesWarning() {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        return (double)this.mostFrequentScore <= ModuleConfig.getParam("quality_sequence", "warn");
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        this.writeDefaultImage(report, "per_sequence_quality.png", "Per Sequence quality graph", 800, 600);
        StringBuffer sb = report.dataDocument();
        sb.append("#Quality\tCount\n");
        int i = 0;
        while (i < this.xCategories.length) {
            sb.append(this.xCategories[i]);
            sb.append("\t");
            sb.append(this.qualityDistribution[i]);
            sb.append("\n");
            ++i;
        }
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }
}

