/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Graphs.BaseGroup;
import uk.ac.babraham.FastQC.Graphs.TileGraph;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.QualityEncoding.PhredEncoding;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Utilities.QualityCount;

public class PerTileQualityScores
extends AbstractQCModule {
    public HashMap<Integer, QualityCount[]> perTileQualityCounts = new HashMap();
    private int currentLength = 0;
    private double[][] means = null;
    private String[] xLabels;
    private int[] tiles;
    private int high = 0;
    PhredEncoding encodingScheme;
    private boolean calculated = false;
    private long totalCount = 0L;
    private int splitPosition = -1;
    private double maxDeviation = 0.0;
    private boolean ignoreInReport = false;

    public JPanel getResultsPanel() {
        if (!this.calculated) {
            this.getPercentages();
        }
        return new TileGraph(this.xLabels, this.tiles, this.means);
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }

    public boolean ignoreInReport() {
        return this.ignoreInReport || ModuleConfig.getParam("tile", "ignore") > 0.0 || this.currentLength == 0;
    }

    private synchronized void getPercentages() {
        char[] range = this.calculateOffsets();
        this.encodingScheme = PhredEncoding.getFastQEncodingOffset(range[0]);
        this.high = range[1] - this.encodingScheme.offset();
        if (this.high < 35) {
            this.high = 35;
        }
        BaseGroup[] groups = BaseGroup.makeBaseGroups(this.currentLength);
        Object[] tileNumbers = this.perTileQualityCounts.keySet().toArray(new Integer[0]);
        Arrays.sort(tileNumbers);
        this.tiles = new int[tileNumbers.length];
        int i = 0;
        while (i < this.tiles.length) {
            this.tiles[i] = (Integer)tileNumbers[i];
            ++i;
        }
        this.means = new double[tileNumbers.length][groups.length];
        this.xLabels = new String[groups.length];
        int t = 0;
        while (t < tileNumbers.length) {
            int i2 = 0;
            while (i2 < groups.length) {
                if (t == 0) {
                    this.xLabels[i2] = groups[i2].toString();
                }
                int minBase = groups[i2].lowerCount();
                int maxBase = groups[i2].upperCount();
                this.means[t][i2] = this.getMean((Integer)tileNumbers[t], minBase, maxBase, this.encodingScheme.offset());
                ++i2;
            }
            ++t;
        }
        double maxDeviation = 0.0;
        double[] averageQualitiesPerGroup = new double[groups.length];
        int t2 = 0;
        while (t2 < tileNumbers.length) {
            int i3 = 0;
            while (i3 < groups.length) {
                int n = i3;
                averageQualitiesPerGroup[n] = averageQualitiesPerGroup[n] + this.means[t2][i3];
                ++i3;
            }
            ++t2;
        }
        int i4 = 0;
        while (i4 < averageQualitiesPerGroup.length) {
            int n = i4++;
            averageQualitiesPerGroup[n] = averageQualitiesPerGroup[n] / (double)tileNumbers.length;
        }
        i4 = 0;
        while (i4 < groups.length) {
            int t3 = 0;
            while (t3 < tileNumbers.length) {
                double[] dArray = this.means[t3];
                int n = i4;
                dArray[n] = dArray[n] - averageQualitiesPerGroup[i4];
                if (Math.abs(this.means[t3][i4]) > maxDeviation) {
                    maxDeviation = Math.abs(this.means[t3][i4]);
                }
                ++t3;
            }
            ++i4;
        }
        this.maxDeviation = maxDeviation;
        this.calculated = true;
    }

    private char[] calculateOffsets() {
        char minChar = '\u0000';
        char maxChar = '\u0000';
        QualityCount[] qualityCounts = this.perTileQualityCounts.get(this.perTileQualityCounts.keySet().toArray()[0]);
        int q = 0;
        while (q < qualityCounts.length) {
            if (q == 0) {
                minChar = qualityCounts[q].getMinChar();
                maxChar = qualityCounts[q].getMaxChar();
            } else {
                if (qualityCounts[q].getMinChar() < minChar) {
                    minChar = qualityCounts[q].getMinChar();
                }
                if (qualityCounts[q].getMaxChar() > maxChar) {
                    maxChar = qualityCounts[q].getMaxChar();
                }
            }
            ++q;
        }
        return new char[]{minChar, maxChar};
    }

    public void processSequence(Sequence sequence) {
        int i;
        QualityCount[] qualityCounts;
        int tile;
        block17: {
            if (this.totalCount == 0L && ModuleConfig.getParam("tile", "ignore") > 0.0) {
                this.ignoreInReport = true;
            }
            if (this.ignoreInReport) {
                return;
            }
            this.calculated = false;
            ++this.totalCount;
            if (this.totalCount % 10L != 0L) {
                return;
            }
            tile = 0;
            String[] splitID = sequence.getID().split(":");
            try {
                if (this.splitPosition >= 0) {
                    if (splitID.length <= this.splitPosition) {
                        throw new NumberFormatException("Can't extract a number - not enough data");
                    }
                    tile = Integer.parseInt(splitID[this.splitPosition]);
                    break block17;
                }
                if (splitID.length >= 7) {
                    this.splitPosition = 4;
                    tile = Integer.parseInt(splitID[4]);
                    break block17;
                }
                if (splitID.length >= 5) {
                    this.splitPosition = 2;
                    tile = Integer.parseInt(splitID[2]);
                    break block17;
                }
                this.ignoreInReport = true;
                return;
            }
            catch (NumberFormatException nfe) {
                this.ignoreInReport = true;
                return;
            }
        }
        char[] qual = sequence.getQualityString().toCharArray();
        if (this.currentLength < qual.length) {
            for (int thisTile : this.perTileQualityCounts.keySet()) {
                QualityCount[] qualityCounts2 = this.perTileQualityCounts.get(thisTile);
                QualityCount[] qualityCountsNew = new QualityCount[qual.length];
                int i2 = 0;
                while (i2 < qualityCounts2.length) {
                    qualityCountsNew[i2] = qualityCounts2[i2];
                    ++i2;
                }
                i2 = qualityCounts2.length;
                while (i2 < qualityCountsNew.length) {
                    qualityCountsNew[i2] = new QualityCount();
                    ++i2;
                }
                this.perTileQualityCounts.put(thisTile, qualityCountsNew);
            }
            this.currentLength = qual.length;
        }
        if (!this.perTileQualityCounts.containsKey(tile)) {
            if (this.perTileQualityCounts.size() > 1000) {
                System.err.println("Too many tiles (>1000) so giving up trying to do per-tile qualities since we're probably parsing the file wrongly");
                this.ignoreInReport = true;
                this.perTileQualityCounts.clear();
                return;
            }
            qualityCounts = new QualityCount[this.currentLength];
            i = 0;
            while (i < this.currentLength) {
                qualityCounts[i] = new QualityCount();
                ++i;
            }
            this.perTileQualityCounts.put(tile, qualityCounts);
        }
        qualityCounts = this.perTileQualityCounts.get(tile);
        i = 0;
        while (i < qual.length) {
            qualityCounts[i].addValue(qual[i]);
            ++i;
        }
    }

    public void reset() {
        this.totalCount = 0L;
        this.perTileQualityCounts = new HashMap();
    }

    public String description() {
        return "Shows the perl tile Quality scores of all bases at a given position in a sequencing run";
    }

    public String name() {
        return "Per tile sequence quality";
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.getPercentages();
        }
        return this.maxDeviation > ModuleConfig.getParam("tile", "error");
    }

    public boolean raisesWarning() {
        if (!this.calculated) {
            this.getPercentages();
        }
        return this.maxDeviation > ModuleConfig.getParam("tile", "warn");
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        if (!this.calculated) {
            this.getPercentages();
        }
        this.writeDefaultImage(report, "per_tile_quality.png", "Per tile quality graph", Math.max(800, this.xLabels.length * 15), 600);
        StringBuffer sb = report.dataDocument();
        sb.append("#Tile\tBase\tMean\n");
        int t = 0;
        while (t < this.tiles.length) {
            int i = 0;
            while (i < this.means[t].length) {
                sb.append(this.tiles[t]);
                sb.append("\t");
                sb.append(this.xLabels[i]);
                sb.append("\t");
                sb.append(this.means[t][i]);
                sb.append("\n");
                ++i;
            }
            ++t;
        }
    }

    private double getMean(int tile, int minbp, int maxbp, int offset) {
        int count = 0;
        double total = 0.0;
        QualityCount[] qualityCounts = this.perTileQualityCounts.get(tile);
        int i = minbp - 1;
        while (i < maxbp) {
            if (qualityCounts[i].getTotalCount() > 0L) {
                ++count;
                total += qualityCounts[i].getMean(offset);
            }
            ++i;
        }
        if (count > 0) {
            return total / (double)count;
        }
        return 0.0;
    }
}

