/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Modules;

import java.io.IOException;
import javax.swing.JPanel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Graphs.LineGraph;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.ModuleConfig;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class SequenceLengthDistribution
extends AbstractQCModule {
    private long[] lengthCounts = new long[0];
    private double[] graphCounts = null;
    private String[] xCategories = new String[0];
    private double max = 0.0;
    private boolean calculated = false;

    public JPanel getResultsPanel() {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        return new LineGraph((double[][])new double[][]{this.graphCounts}, 0.0, this.max, "Sequence Length (bp)", new String[]{"Sequence Length"}, this.xCategories, "Distribution of sequence lengths over all sequences");
    }

    public boolean ignoreFilteredSequences() {
        return true;
    }

    public boolean ignoreInReport() {
        return ModuleConfig.getParam("sequence_length", "ignore") > 0.0;
    }

    private synchronized void calculateDistribution() {
        int maxLen = 0;
        int minLen = -1;
        this.max = 0.0;
        int i = 0;
        while (i < this.lengthCounts.length) {
            if (this.lengthCounts[i] > 0L) {
                if (minLen < 0) {
                    minLen = i;
                }
                maxLen = i;
            }
            ++i;
        }
        if (minLen < 0) {
            minLen = 0;
        }
        if (minLen > 0) {
            --minLen;
        }
        int[] startAndInterval = this.getSizeDistribution(minLen, ++maxLen);
        int categories = 0;
        int currentValue = startAndInterval[0];
        while (currentValue <= maxLen) {
            ++categories;
            currentValue += startAndInterval[1];
        }
        this.graphCounts = new double[categories];
        this.xCategories = new String[categories];
        int i2 = 0;
        while (i2 < this.graphCounts.length) {
            int minValue = startAndInterval[0] + startAndInterval[1] * i2;
            int maxValue = startAndInterval[0] + startAndInterval[1] * (i2 + 1) - 1;
            if (maxValue > maxLen) {
                maxValue = maxLen;
            }
            int bp = minValue;
            while (bp <= maxValue) {
                if (bp < this.lengthCounts.length) {
                    int n = i2;
                    this.graphCounts[n] = this.graphCounts[n] + (double)this.lengthCounts[bp];
                }
                ++bp;
            }
            this.xCategories[i2] = startAndInterval[1] == 1 ? "" + minValue : String.valueOf(minValue) + "-" + maxValue;
            if (this.graphCounts[i2] > this.max) {
                this.max = this.graphCounts[i2];
            }
            ++i2;
        }
        this.calculated = true;
    }

    public void processSequence(Sequence sequence) {
        int seqLen = sequence.getSequence().length();
        if (seqLen + 2 > this.lengthCounts.length) {
            long[] newLengthCounts = new long[seqLen + 2];
            int i = 0;
            while (i < this.lengthCounts.length) {
                newLengthCounts[i] = this.lengthCounts[i];
                ++i;
            }
            this.lengthCounts = newLengthCounts;
        }
        int n = seqLen;
        this.lengthCounts[n] = this.lengthCounts[n] + 1L;
    }

    private int[] getSizeDistribution(int min, int max) {
        int testStart;
        int tester;
        if (FastQCConfig.getInstance().nogroup) {
            return new int[]{min, 1};
        }
        int base = 1;
        while (base > max - min) {
            base /= 10;
        }
        int[] divisions = new int[]{1, 2, 5};
        block1: while (true) {
            int d = 0;
            while (d < divisions.length) {
                tester = base * divisions[d];
                if ((max - min) / tester <= 50) break block1;
                ++d;
            }
            base *= 10;
        }
        int interval = tester;
        int basicDivision = min / interval;
        int starting = testStart = basicDivision * interval;
        return new int[]{starting, interval};
    }

    public void reset() {
        this.lengthCounts = new long[0];
    }

    public String description() {
        return "Shows the distribution of sequence length over all sequences";
    }

    public String name() {
        return "Sequence Length Distribution";
    }

    public boolean raisesError() {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        if (ModuleConfig.getParam("sequence_length", "error") == 0.0) {
            return false;
        }
        return this.lengthCounts.length > 0 && this.lengthCounts[0] > 0L;
    }

    public boolean raisesWarning() {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        if (ModuleConfig.getParam("sequence_length", "warn") == 0.0) {
            return false;
        }
        boolean seenLength = false;
        int i = 0;
        while (i < this.lengthCounts.length) {
            if (this.lengthCounts[i] > 0L) {
                if (seenLength) {
                    return true;
                }
                seenLength = true;
            }
            ++i;
        }
        return false;
    }

    public void makeReport(HTMLReportArchive report) throws IOException, XMLStreamException {
        if (!this.calculated) {
            this.calculateDistribution();
        }
        this.writeDefaultImage(report, "sequence_length_distribution.png", "Sequence length distribution", Math.max(800, this.graphCounts.length * 15), 600);
        StringBuffer sb = report.dataDocument();
        sb.append("#Length\tCount\n");
        int i = 0;
        while (i < this.xCategories.length) {
            if (i != 0 && i != this.xCategories.length - 1 || this.graphCounts[i] != 0.0) {
                sb.append(this.xCategories[i]);
                sb.append("\t");
                sb.append(this.graphCounts[i]);
                sb.append("\n");
            }
            ++i;
        }
    }
}

