/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Report;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Utilities.ImageToBase64;

public class HTMLReportArchive {
    private XMLStreamWriter xhtml = null;
    private StringBuffer data = new StringBuffer();
    private QCModule[] modules;
    private ZipOutputStream zip;
    private SequenceFile sequenceFile;
    private byte[] buffer = new byte[1024];
    private File htmlFile;
    private File zipFile;

    public HTMLReportArchive(SequenceFile sequenceFile, QCModule[] modules, File htmlFile) throws IOException, XMLStreamException {
        this.sequenceFile = sequenceFile;
        this.modules = modules;
        this.htmlFile = htmlFile;
        this.zipFile = new File(String.valueOf(htmlFile.getAbsoluteFile().toString().replaceAll("\\.html$", "")) + ".zip");
        StringWriter htmlStr = new StringWriter();
        XMLOutputFactory xmlfactory = XMLOutputFactory.newInstance();
        this.xhtml = xmlfactory.createXMLStreamWriter(htmlStr);
        this.zip = new ZipOutputStream(new FileOutputStream(this.zipFile));
        this.zip.putNextEntry(new ZipEntry(String.valueOf(this.folderName()) + "/"));
        this.zip.putNextEntry(new ZipEntry(String.valueOf(this.folderName()) + "/Icons/"));
        this.zip.putNextEntry(new ZipEntry(String.valueOf(this.folderName()) + "/Images/"));
        this.startDocument();
        int m = 0;
        while (m < modules.length) {
            if (!modules[m].ignoreInReport()) {
                this.xhtml.writeStartElement("div");
                this.xhtml.writeAttribute("class", "module");
                this.xhtml.writeStartElement("h2");
                this.xhtml.writeAttribute("id", "M" + m);
                if (modules[m].raisesError()) {
                    this.xhtml.writeEmptyElement("img");
                    this.xhtml.writeAttribute("src", this.base64ForIcon("Icons/error.png"));
                    this.xhtml.writeAttribute("alt", "[FAIL]");
                } else if (modules[m].raisesWarning()) {
                    this.xhtml.writeEmptyElement("img");
                    this.xhtml.writeAttribute("src", this.base64ForIcon("Icons/warning.png"));
                    this.xhtml.writeAttribute("alt", "[WARN]");
                } else {
                    this.xhtml.writeEmptyElement("img");
                    this.xhtml.writeAttribute("src", this.base64ForIcon("Icons/tick.png"));
                    this.xhtml.writeAttribute("alt", "[OK]");
                }
                this.xhtml.writeCharacters(modules[m].name());
                this.data.append(">>");
                this.data.append(modules[m].name());
                this.data.append("\t");
                if (modules[m].raisesError()) {
                    this.data.append("fail");
                } else if (modules[m].raisesWarning()) {
                    this.data.append("warn");
                } else {
                    this.data.append("pass");
                }
                this.data.append("\n");
                this.xhtml.writeEndElement();
                modules[m].makeReport(this);
                this.data.append(">>END_MODULE\n");
                this.xhtml.writeEndElement();
            }
            ++m;
        }
        this.closeDocument();
        this.zip.putNextEntry(new ZipEntry(String.valueOf(this.folderName()) + "/fastqc_report.html"));
        this.xhtml.flush();
        this.xhtml.close();
        this.zip.write(htmlStr.toString().getBytes());
        this.zip.closeEntry();
        this.zip.putNextEntry(new ZipEntry(String.valueOf(this.folderName()) + "/fastqc_data.txt"));
        this.zip.write(this.data.toString().getBytes());
        this.zip.closeEntry();
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(false);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document src = builder.parse(new InputSource(new StringReader(htmlStr.toString())));
            InputStream rsrc = this.getClass().getResourceAsStream("/Templates/fastqc2fo.xsl");
            if (rsrc != null) {
                domFactory.setNamespaceAware(true);
                builder = domFactory.newDocumentBuilder();
                Document html2fo = builder.parse(rsrc);
                rsrc.close();
                TransformerFactory tf = TransformerFactory.newInstance();
                Templates templates = tf.newTemplates(new DOMSource(html2fo));
                this.zip.putNextEntry(new ZipEntry(String.valueOf(this.folderName()) + "/fastqc.fo"));
                templates.newTransformer().transform(new DOMSource(src), new StreamResult(this.zip));
                this.zip.closeEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.zip.close();
        PrintWriter pr = new PrintWriter(new FileWriter(htmlFile));
        pr.print(htmlStr.toString());
        pr.close();
        if (FastQCConfig.getInstance().do_unzip.booleanValue()) {
            this.unzipZipFile(this.zipFile);
        }
    }

    private void unzipZipFile(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        byte[] buffer = new byte[1024];
        while (entries.hasMoreElements()) {
            int size;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                File dir = new File(String.valueOf(file.getParent()) + "/" + entry.getName());
                if (dir.exists() && dir.isDirectory()) continue;
                if (dir.exists() && !dir.isDirectory()) {
                    throw new IOException("File exists with dir name " + dir.getName());
                }
                if (dir.mkdir()) continue;
                throw new IOException("Failed to make dir for " + dir.getName());
            }
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(String.valueOf(file.getParent()) + "/" + entry.getName()), buffer.length);
            while ((size = bis.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
            bis.close();
        }
        zipFile.close();
    }

    public XMLStreamWriter xhtmlStream() {
        return this.xhtml;
    }

    public StringBuffer dataDocument() {
        return this.data;
    }

    public String folderName() {
        return this.htmlFile.getName().replaceAll("\\.html$", "");
    }

    public ZipOutputStream zipFile() {
        return this.zip;
    }

    private void startDocument() throws IOException, XMLStreamException {
        this.data.append("##FastQC\t");
        this.data.append("0.11.9");
        this.data.append("\n");
        String[] stringArray = new String[]{"fastqc_icon.png", "warning.png", "error.png", "tick.png"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String icnName = stringArray[n2];
            InputStream in = this.getClass().getResourceAsStream("/Templates/Icons/" + icnName);
            if (in != null) {
                int len;
                this.zip.putNextEntry(new ZipEntry(String.valueOf(this.folderName()) + "/Icons/" + icnName));
                while ((len = in.read(this.buffer)) > 0) {
                    this.zip.write(this.buffer, 0, len);
                }
                in.close();
                this.zip.closeEntry();
            }
            ++n2;
        }
        SimpleDateFormat df = new SimpleDateFormat("EEE d MMM yyyy");
        this.xhtml.writeStartElement("html");
        this.xhtml.writeStartElement("head");
        this.xhtml.writeStartElement("title");
        this.xhtml.writeCharacters(this.sequenceFile.name());
        this.xhtml.writeCharacters(" FastQC Report");
        this.xhtml.writeEndElement();
        InputStream rsrc = this.getClass().getResourceAsStream("/Templates/header_template.html");
        if (rsrc != null) {
            int nRead;
            this.xhtml.writeStartElement("style");
            this.xhtml.writeAttribute("type", "text/css");
            byte[] array = new byte[128];
            while ((nRead = rsrc.read(array)) != -1) {
                this.xhtml.writeCharacters(new String(array, 0, nRead));
            }
            rsrc.close();
            this.xhtml.writeEndElement();
        }
        this.xhtml.writeEndElement();
        this.xhtml.writeStartElement("body");
        this.xhtml.writeStartElement("div");
        this.xhtml.writeAttribute("class", "header");
        this.xhtml.writeStartElement("div");
        this.xhtml.writeAttribute("id", "header_title");
        this.xhtml.writeEmptyElement("img");
        this.xhtml.writeAttribute("src", this.base64ForIcon("Icons/fastqc_icon.png"));
        this.xhtml.writeAttribute("alt", "FastQC");
        this.xhtml.writeCharacters("FastQC Report");
        this.xhtml.writeEndElement();
        this.xhtml.writeStartElement("div");
        this.xhtml.writeAttribute("id", "header_filename");
        this.xhtml.writeCharacters(df.format(new Date()));
        this.xhtml.writeEmptyElement("br");
        this.xhtml.writeCharacters(this.sequenceFile.name());
        this.xhtml.writeEndElement();
        this.xhtml.writeEndElement();
        this.xhtml.writeStartElement("div");
        this.xhtml.writeAttribute("class", "summary");
        this.xhtml.writeStartElement("h2");
        this.xhtml.writeCharacters("Summary");
        this.xhtml.writeEndElement();
        this.xhtml.writeStartElement("ul");
        StringBuffer summaryText = new StringBuffer();
        int m = 0;
        while (m < this.modules.length) {
            if (!this.modules[m].ignoreInReport()) {
                this.xhtml.writeStartElement("li");
                this.xhtml.writeEmptyElement("img");
                if (this.modules[m].raisesError()) {
                    this.xhtml.writeAttribute("src", this.base64ForIcon("Icons/error.png"));
                    this.xhtml.writeAttribute("alt", "[FAIL]");
                    summaryText.append("FAIL");
                } else if (this.modules[m].raisesWarning()) {
                    this.xhtml.writeAttribute("src", this.base64ForIcon("Icons/warning.png"));
                    this.xhtml.writeAttribute("alt", "[WARNING]");
                    summaryText.append("WARN");
                } else {
                    this.xhtml.writeAttribute("src", this.base64ForIcon("Icons/tick.png"));
                    this.xhtml.writeAttribute("alt", "[PASS]");
                    summaryText.append("PASS");
                }
                summaryText.append("\t");
                summaryText.append(this.modules[m].name());
                summaryText.append("\t");
                summaryText.append(this.sequenceFile.name());
                summaryText.append(FastQCConfig.getInstance().lineSeparator);
                this.xhtml.writeStartElement("a");
                this.xhtml.writeAttribute("href", "#M" + m);
                this.xhtml.writeCharacters(this.modules[m].name());
                this.xhtml.writeEndElement();
                this.xhtml.writeEndElement();
            }
            ++m;
        }
        this.xhtml.writeEndElement();
        this.xhtml.writeEndElement();
        this.xhtml.writeStartElement("div");
        this.xhtml.writeAttribute("class", "main");
        this.zip.putNextEntry(new ZipEntry(String.valueOf(this.folderName()) + "/summary.txt"));
        this.zip.write(summaryText.toString().getBytes());
    }

    private String base64ForIcon(String path) {
        try {
            BufferedImage b = ImageIO.read(ClassLoader.getSystemResource("Templates/" + path));
            return ImageToBase64.imageToBase64(b);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "Failed";
        }
    }

    private void closeDocument() throws XMLStreamException {
        this.xhtml.writeEndElement();
        this.xhtml.writeStartElement("div");
        this.xhtml.writeAttribute("class", "footer");
        this.xhtml.writeCharacters("Produced by ");
        this.xhtml.writeStartElement("a");
        this.xhtml.writeAttribute("href", "http://www.bioinformatics.babraham.ac.uk/projects/fastqc/");
        this.xhtml.writeCharacters("FastQC");
        this.xhtml.writeEndElement();
        this.xhtml.writeCharacters("  (version 0.11.9)");
        this.xhtml.writeEndElement();
        this.xhtml.writeEndElement();
        this.xhtml.writeEndElement();
    }
}

