/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Sequence.Contaminant;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Sequence.Contaminant.Contaminant;
import uk.ac.babraham.FastQC.Sequence.Contaminant.ContaminantHit;

public class ContaminentFinder {
    private static Contaminant[] contaminants;

    public static ContaminantHit findContaminantHit(String sequence) {
        if (contaminants == null) {
            contaminants = ContaminentFinder.makeContaminantList();
        }
        ContaminantHit bestHit = null;
        int c = 0;
        while (c < contaminants.length) {
            ContaminantHit thisHit = contaminants[c].findMatch(sequence);
            if (thisHit != null && (bestHit == null || thisHit.length() > bestHit.length())) {
                bestHit = thisHit;
            }
            ++c;
        }
        return bestHit;
    }

    private static Contaminant[] makeContaminantList() {
        Vector<Contaminant> c = new Vector<Contaminant>();
        try {
            String line;
            BufferedReader br = null;
            if (FastQCConfig.getInstance().contaminant_file == null) {
                InputStream rsrc = ContaminentFinder.class.getResourceAsStream("/Configuration/contaminant_list.txt");
                if (rsrc == null) {
                    throw new FileNotFoundException("cannot find Confituration/contaminant_list.txt");
                }
                br = new BufferedReader(new InputStreamReader(rsrc));
            } else {
                br = new BufferedReader(new FileReader(FastQCConfig.getInstance().contaminant_file));
            }
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                String[] sections = line.split("\\t+");
                if (sections.length != 2) {
                    System.err.println("Expected 2 sections for contaminant line but got " + sections.length + " from " + line);
                    continue;
                }
                Contaminant con = new Contaminant(sections[0], sections[1]);
                c.add(con);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return c.toArray(new Contaminant[0]);
    }
}

