/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Sequence;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5SimpleReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;

public class Fast5File
implements SequenceFile {
    private Sequence nextSequence = null;
    private File file;
    private String name;
    private IHDF5SimpleReader reader;
    private String[] readPaths = new String[]{""};
    private int readPathsIndexPosition = 0;
    private String[] rdfPaths = new String[]{"Analyses/Basecall_2D_000/BaseCalled_template/Fastq", "Analyses/Basecall_2D_000/BaseCalled_2D/Fastq", "Analyses/Basecall_1D_000/BaseCalled_template/Fastq", "Analyses/Basecall_1D_000/BaseCalled_1D/Fastq"};

    protected Fast5File(File file) throws SequenceFormatException, IOException {
        this.file = file;
        this.name = file.getName();
        this.reader = HDF5Factory.openForReading((File)file);
        List topLevelFolders = this.reader.getGroupMembers("/");
        ArrayList<String> readFolders = new ArrayList<String>();
        for (String folder : topLevelFolders) {
            System.err.println("Looking at " + folder);
            if (!folder.startsWith("read_")) continue;
            readFolders.add(String.valueOf(folder) + "/");
        }
        if (readFolders.size() > 0) {
            this.readPaths = readFolders.toArray(new String[0]);
        }
    }

    public String name() {
        return this.name;
    }

    public int getPercentComplete() {
        return this.readPathsIndexPosition * 100 / this.readPaths.length;
    }

    public boolean isColorspace() {
        return false;
    }

    public boolean hasNext() {
        return this.readPathsIndexPosition < this.readPaths.length;
    }

    public Sequence next() throws SequenceFormatException {
        int r = 0;
        while (r < this.rdfPaths.length) {
            if (this.reader.exists(String.valueOf(this.readPaths[this.readPathsIndexPosition]) + this.rdfPaths[r])) {
                String fastq = this.reader.readString(String.valueOf(this.readPaths[this.readPathsIndexPosition]) + this.rdfPaths[r]);
                String[] sections = fastq.split("\\n");
                if (sections.length != 4) {
                    throw new SequenceFormatException("Didn't get 4 sections from " + fastq);
                }
                Sequence seq = new Sequence(this, sections[1].toUpperCase(), sections[3], sections[0]);
                ++this.readPathsIndexPosition;
                if (this.readPathsIndexPosition >= this.readPaths.length) {
                    this.reader.close();
                }
                return seq;
            }
            ++r;
        }
        throw new SequenceFormatException("No valid fastq paths found in " + this.file);
    }

    public void remove() {
    }

    public File getFile() {
        return this.file;
    }
}

