/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Sequence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.itadaki.bzip2.BZip2InputStream;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;
import uk.ac.babraham.FastQC.Utilities.MultiMemberGZIPInputStream;

public class FastQFile
implements SequenceFile {
    private Sequence nextSequence = null;
    private File file;
    private long fileSize = 0L;
    private boolean casavaMode = false;
    private boolean nofilter = false;
    private BufferedReader br;
    private FileInputStream fis;
    private String name;
    private boolean isColorspace = false;

    protected FastQFile(FastQCConfig config, File file) throws SequenceFormatException, IOException {
        this.file = file;
        this.fileSize = file.getName().startsWith("stdin") ? Long.MAX_VALUE : file.length();
        this.name = file.getName();
        if (config.casava) {
            this.casavaMode = true;
            if (config.nofilter) {
                this.nofilter = true;
            }
        }
        if (!file.getName().startsWith("stdin")) {
            this.fis = new FileInputStream(file);
        }
        this.br = file.getName().startsWith("stdin") ? new BufferedReader(new InputStreamReader(System.in)) : (file.getName().toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(this.fis))) : (file.getName().toLowerCase().endsWith(".bz2") ? new BufferedReader(new InputStreamReader((InputStream)new BZip2InputStream((InputStream)this.fis, false))) : new BufferedReader(new InputStreamReader(this.fis))));
        this.readNext();
    }

    public String name() {
        return this.name;
    }

    public int getPercentComplete() {
        if (!this.hasNext()) {
            return 100;
        }
        if (this.file.getName().startsWith("stdin")) {
            return 0;
        }
        try {
            int percent = (int)((double)this.fis.getChannel().position() / (double)this.fileSize * 100.0);
            return percent;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isColorspace() {
        return this.isColorspace;
    }

    public void setIsColorspace(boolean isColorspace) {
        this.isColorspace = isColorspace;
    }

    public boolean hasNext() {
        return this.nextSequence != null;
    }

    public Sequence next() throws SequenceFormatException {
        Sequence seq = this.nextSequence;
        this.readNext();
        return seq;
    }

    private void readNext() throws SequenceFormatException {
        try {
            String quality;
            String seq;
            String id;
            do {
                if ((id = this.br.readLine()) != null) continue;
                this.nextSequence = null;
                this.br.close();
                if (this.fis != null) {
                    this.fis.close();
                }
                return;
            } while (id.length() == 0);
            if (!id.startsWith("@")) {
                this.nextSequence = null;
                throw new SequenceFormatException("ID line didn't start with '@'");
            }
            try {
                seq = this.br.readLine();
                if (seq == null) {
                    throw new IOException("No more data");
                }
                String midLine = this.br.readLine();
                if (midLine == null) {
                    throw new IOException("No more data");
                }
                if (!midLine.startsWith("+")) {
                    throw new SequenceFormatException("Midline '" + midLine + "' didn't start with '+'");
                }
                quality = this.br.readLine();
                if (quality == null) {
                    throw new IOException("No more data");
                }
            }
            catch (IOException ioe) {
                throw new SequenceFormatException("Ran out of data in the middle of a fastq entry.  Your file is probably truncated");
            }
            if (this.nextSequence == null && seq != null) {
                this.checkColorspace(seq);
            }
            this.nextSequence = this.isColorspace() ? new Sequence(this, this.convertColorspaceToBases(seq.toUpperCase()), seq.toUpperCase(), quality, id) : new Sequence(this, seq.toUpperCase(), quality, id);
            if (this.casavaMode && !this.nofilter && id.indexOf(":Y:") > 0) {
                this.nextSequence.setIsFiltered(true);
            }
        }
        catch (IOException ioe) {
            this.nextSequence = null;
            ioe.printStackTrace();
        }
    }

    private void checkColorspace(String seq) {
        String regex = "^[GATCNgatcn][\\.0123456]+$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(seq);
        this.isColorspace = matcher.find();
    }

    private String convertColorspaceToBases(String s) {
        char[] cs = s.toUpperCase().toCharArray();
        if (cs.length == 0) {
            return "";
        }
        char[] bp = new char[cs.length - 1];
        int i = 1;
        while (i < cs.length) {
            char refBase = i == 1 ? cs[i - 1] : bp[i - 2];
            if (refBase != 'G' && refBase != 'A' && refBase != 'T' && refBase != 'C') {
                throw new IllegalArgumentException("Colourspace sequence data should always start with a real DNA letter.  Line '" + s + "' started with " + refBase + " at position " + i);
            }
            switch (cs[i]) {
                case '0': {
                    switch (refBase) {
                        case 'G': {
                            bp[i - 1] = 71;
                            break;
                        }
                        case 'A': {
                            bp[i - 1] = 65;
                            break;
                        }
                        case 'T': {
                            bp[i - 1] = 84;
                            break;
                        }
                        case 'C': {
                            bp[i - 1] = 67;
                        }
                    }
                    break;
                }
                case '1': {
                    switch (refBase) {
                        case 'G': {
                            bp[i - 1] = 84;
                            break;
                        }
                        case 'A': {
                            bp[i - 1] = 67;
                            break;
                        }
                        case 'T': {
                            bp[i - 1] = 71;
                            break;
                        }
                        case 'C': {
                            bp[i - 1] = 65;
                        }
                    }
                    break;
                }
                case '2': {
                    switch (refBase) {
                        case 'G': {
                            bp[i - 1] = 65;
                            break;
                        }
                        case 'A': {
                            bp[i - 1] = 71;
                            break;
                        }
                        case 'T': {
                            bp[i - 1] = 67;
                            break;
                        }
                        case 'C': {
                            bp[i - 1] = 84;
                        }
                    }
                    break;
                }
                case '3': {
                    switch (refBase) {
                        case 'G': {
                            bp[i - 1] = 67;
                            break;
                        }
                        case 'A': {
                            bp[i - 1] = 84;
                            break;
                        }
                        case 'T': {
                            bp[i - 1] = 65;
                            break;
                        }
                        case 'C': {
                            bp[i - 1] = 71;
                        }
                    }
                    break;
                }
                case '.': 
                case '4': 
                case '5': 
                case '6': {
                    while (i < cs.length) {
                        bp[i - 1] = 78;
                        ++i;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected cs char " + cs[i]);
                }
            }
            ++i;
        }
        return new String(bp);
    }

    public void remove() {
    }

    public File getFile() {
        return this.file;
    }
}

