/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Sequence;

import java.io.File;
import java.io.IOException;
import uk.ac.babraham.FastQC.FastQCConfig;
import uk.ac.babraham.FastQC.Sequence.BAMFile;
import uk.ac.babraham.FastQC.Sequence.Fast5File;
import uk.ac.babraham.FastQC.Sequence.FastQFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFileGroup;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;
import uk.ac.babraham.FastQC.Utilities.CasavaBasename;
import uk.ac.babraham.FastQC.Utilities.NameFormatException;

public class SequenceFactory {
    public static SequenceFile getSequenceFile(File[] files) throws SequenceFormatException, IOException {
        if (files.length == 1) {
            if (FastQCConfig.getInstance().casava) {
                try {
                    CasavaBasename.getCasavaBasename(files[0].getName());
                }
                catch (NameFormatException nfe) {
                    return SequenceFactory.getSequenceFile(files[0]);
                }
            } else {
                return SequenceFactory.getSequenceFile(files[0]);
            }
        }
        return new SequenceFileGroup(files);
    }

    public static SequenceFile getSequenceFile(File file) throws SequenceFormatException, IOException {
        FastQCConfig config = FastQCConfig.getInstance();
        if (config.sequence_format != null) {
            if (config.sequence_format.equals("bam") || config.sequence_format.equals("sam")) {
                return new BAMFile(file, false);
            }
            if (config.sequence_format.equals("bam_mapped") || config.sequence_format.equals("sam_mapped")) {
                return new BAMFile(file, true);
            }
            if (config.sequence_format.equals("fastq")) {
                return new FastQFile(config, file);
            }
            throw new SequenceFormatException("Didn't understand format name '" + config.sequence_format + "'");
        }
        if (file.getName().toLowerCase().endsWith(".bam") || file.getName().toLowerCase().endsWith(".sam")) {
            return new BAMFile(file, false);
        }
        if (file.getName().toLowerCase().endsWith(".fast5")) {
            return new Fast5File(file);
        }
        return new FastQFile(config, file);
    }
}

