/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Statistics;

public class PearsonCorrelation {
    public static float calculateCorrelation(long[] data1, long[] data2) {
        float[] d1 = new float[data1.length];
        float[] d2 = new float[data2.length];
        int i = 0;
        while (i < data1.length) {
            d1[i] = data1[i];
            ++i;
        }
        i = 0;
        while (i < data2.length) {
            d2[i] = data2[i];
            ++i;
        }
        return PearsonCorrelation.calculateCorrelation(d1, d2);
    }

    public static float calculateCorrelation(long[] data1, long[] data2, int offset) {
        float[] d1 = new float[data1.length - offset];
        float[] d2 = new float[data2.length - offset];
        int i = 0;
        while (i < d1.length) {
            d1[i] = data1[i];
            ++i;
        }
        i = 0;
        while (i < d2.length) {
            d2[i] = data2[i + offset];
            ++i;
        }
        return PearsonCorrelation.calculateCorrelation(d1, d2);
    }

    public static float calculateCorrelation(float[] data1, float[] data2) {
        if (data1.length != data2.length) {
            throw new IllegalArgumentException("Data sets must be the same length when calculating correlation");
        }
        float sum12 = 0.0f;
        float sum1 = 0.0f;
        float sum2 = 0.0f;
        float sum1square = 0.0f;
        float sum2square = 0.0f;
        int i = 0;
        while (i < data1.length) {
            sum12 += data1[i] * data2[i];
            sum1 += data1[i];
            sum2 += data2[i];
            sum1square += data1[i] * data1[i];
            sum2square += data2[i] * data2[i];
            ++i;
        }
        float top = sum12 - sum1 * sum2 / (float)data1.length;
        float bottomRight = sum2square - sum2 * sum2 / (float)data1.length;
        float bottomLeft = sum1square - sum1 * sum1 / (float)data1.length;
        float bottom = (float)Math.sqrt(bottomLeft * bottomRight);
        return top / bottom;
    }
}

