/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Utilities;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import uk.ac.babraham.FastQC.Utilities.NameFormatException;

public class CasavaBasename {
    public static String getCasavaBasename(String originalName) throws NameFormatException {
        if (originalName.endsWith(".fastq.gz")) {
            if (originalName.substring(originalName.length() - 13, originalName.length() - 12).equals("_")) {
                try {
                    Integer.parseInt(originalName.substring(originalName.length() - 12, originalName.length() - 9));
                    String baseName = String.valueOf(originalName.substring(0, originalName.length() - 13)) + ".fastq.gz";
                    return baseName;
                }
                catch (NumberFormatException baseName) {}
            }
        } else if (originalName.endsWith(".fastq") && originalName.substring(originalName.length() - 10, originalName.length() - 9).equals("_")) {
            try {
                Integer.parseInt(originalName.substring(originalName.length() - 9, originalName.length() - 6));
                String baseName = String.valueOf(originalName.substring(0, originalName.length() - 10)) + ".fastq";
                return baseName;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new NameFormatException();
    }

    public static File[][] getCasavaGroups(File[] files) {
        Hashtable fileBases = new Hashtable();
        int f = 0;
        while (f < files.length) {
            try {
                String baseName = CasavaBasename.getCasavaBasename(files[f].getName());
                if (!fileBases.containsKey(baseName)) {
                    fileBases.put(baseName, new Vector());
                }
                ((Vector)fileBases.get(baseName)).add(files[f]);
            }
            catch (NameFormatException nfe) {
                System.err.println("File '" + files[f].getName() + "' didn't look like part of a CASAVA group");
                Vector<File> newVector = new Vector<File>();
                newVector.add(files[f]);
                fileBases.put(files[f].getName(), newVector);
            }
            ++f;
        }
        String[] baseNames = fileBases.keySet().toArray(new String[0]);
        File[][] fileGroups = new File[baseNames.length][];
        int i = 0;
        while (i < baseNames.length) {
            fileGroups[i] = ((Vector)fileBases.get(baseNames[i])).toArray(new File[0]);
            ++i;
        }
        return fileGroups;
    }
}

