/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Utilities;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import uk.ac.babraham.FastQC.Utilities.NameFormatException;

public class NanoporeBasename {
    public static String getNanoporeBasename(String originalName) throws NameFormatException {
        String[] subNames = originalName.replaceAll(".fast5$", "").split("_");
        if (subNames.length < 3) {
            throw new NameFormatException();
        }
        String basename = String.valueOf(subNames[0]) + "_" + subNames[1] + "_" + subNames[2];
        System.err.println("Basename is " + basename);
        return basename;
    }

    public static File[][] getNanoporeGroups(File[] files) {
        Hashtable fileBases = new Hashtable();
        int f = 0;
        while (f < files.length) {
            if (!files[f].getName().contains("muxscan")) {
                try {
                    String baseName = NanoporeBasename.getNanoporeBasename(files[f].getName());
                    if (!fileBases.containsKey(baseName)) {
                        fileBases.put(baseName, new Vector());
                    }
                    ((Vector)fileBases.get(baseName)).add(files[f]);
                }
                catch (NameFormatException nfe) {
                    System.err.println("File '" + files[f].getName() + "' didn't look like part of a CASAVA group");
                    Vector<File> newVector = new Vector<File>();
                    newVector.add(files[f]);
                    fileBases.put(files[f].getName(), newVector);
                }
            }
            ++f;
        }
        String[] baseNames = fileBases.keySet().toArray(new String[0]);
        File[][] fileGroups = new File[baseNames.length][];
        int i = 0;
        while (i < baseNames.length) {
            fileGroups[i] = ((Vector)fileBases.get(baseNames[i])).toArray(new File[0]);
            ++i;
        }
        return fileGroups;
    }
}

