/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Utilities;

public class QualityCount {
    private long[] actualCounts = new long[150];
    private long totalCounts = 0L;

    public void addValue(char c) {
        ++this.totalCounts;
        char c2 = c;
        this.actualCounts[c2] = this.actualCounts[c2] + 1L;
    }

    public long getTotalCount() {
        return this.totalCounts;
    }

    public char getMinChar() {
        int i = 0;
        while (i < this.actualCounts.length) {
            if (this.actualCounts[i] > 0L) {
                return (char)i;
            }
            ++i;
        }
        return '\u03e8';
    }

    public char getMaxChar() {
        int i = this.actualCounts.length - 1;
        while (i >= 0) {
            if (this.actualCounts[i] > 0L) {
                return (char)i;
            }
            --i;
        }
        return '\u03e8';
    }

    public double getMean(int offset) {
        long total = 0L;
        long count = 0L;
        int i = offset;
        while (i < this.actualCounts.length) {
            total += this.actualCounts[i] * (long)(i - offset);
            count += this.actualCounts[i];
            ++i;
        }
        return (double)total / (double)count;
    }

    public double getPercentile(int offset, int percentile) {
        long total = this.totalCounts;
        total *= (long)percentile;
        total /= 100L;
        long count = 0L;
        int i = offset;
        while (i < this.actualCounts.length) {
            if ((count += this.actualCounts[i]) >= total) {
                return (char)(i - offset);
            }
            ++i;
        }
        return -1.0;
    }
}

