/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Polymorphism;
import core.SampleRanges;
import core.TestSample;
import dataVisualizers.OverviewTree;
import dataVisualizers.PhylotreeRenderer;
import exceptions.parse.HsdFileException;
import exceptions.parse.samplefile.UniqueSampleIDException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import phylotree.Phylotree;
import qualityAssurance.QualityAssistent;
import qualityAssurance.RuleSet;
import qualityAssurance.issues.QualityIssue;
import search.ranking.RankingMethod;
import search.ranking.results.RankedResult;

public class SampleFile {
    Hashtable<String, TestSample> testSamples = new Hashtable();
    QualityAssistent qualityAssistent = null;
    Phylotree usedPhyloTreeLastRun = null;
    RankingMethod usedRankingMethodLastRun = null;

    public SampleFile(ArrayList<String> sampleLines) throws HsdFileException {
        int lineIndex = 1;
        for (String currentLine : sampleLines) {
            TestSample newSample;
            try {
                String[] splits = currentLine.split("\t");
                if (splits.length == 2) {
                    StringBuilder build = new StringBuilder();
                    build.append(splits[0] + "\t");
                    build.append(splits[1] + "\t?\t.");
                    currentLine = build.toString();
                }
                newSample = TestSample.parse(currentLine);
            }
            catch (HsdFileException e) {
                e.setLineExceptionOccured(lineIndex);
                throw e;
            }
            if (this.testSamples.containsKey(newSample.getSampleID())) {
                try {
                    throw new UniqueSampleIDException();
                }
                catch (UniqueSampleIDException e) {
                    e.setLineExceptionOccured(lineIndex);
                    e.setTestSampleeID(newSample.getSampleID());
                    throw e;
                }
            }
            this.testSamples.put(newSample.getSampleID(), newSample);
            ++lineIndex;
        }
    }

    public SampleFile(String pathToSampleFile, boolean testCase) throws HsdFileException, IOException {
        TestSample newSample;
        BufferedReader sampleFileStream;
        if (testCase) {
            String userDir = new File("").getAbsolutePath();
            File sampleFile = new File(userDir + pathToSampleFile);
            sampleFileStream = new BufferedReader(new FileReader(sampleFile));
        } else {
            InputStream testFile = this.getClass().getClassLoader().getResourceAsStream(pathToSampleFile);
            sampleFileStream = new BufferedReader(new InputStreamReader(testFile));
        }
        String currentLine = sampleFileStream.readLine();
        if (!currentLine.startsWith("SampleId\tRange")) {
            newSample = TestSample.parse(currentLine);
            this.testSamples.put(newSample.getSampleID(), newSample);
        }
        while ((currentLine = sampleFileStream.readLine()) != null) {
            newSample = TestSample.parse(currentLine);
            this.testSamples.put(newSample.getSampleID(), newSample);
        }
    }

    public SampleFile() {
    }

    public void setTestSamples(ArrayList<TestSample> file) {
        this.testSamples.clear();
        for (TestSample currentSample : file) {
            this.testSamples.put(currentSample.getSampleID(), currentSample);
        }
    }

    public TestSample getTestSample(String sampleID) {
        return this.testSamples.get(sampleID);
    }

    public ArrayList<TestSample> getTestSamples() {
        return new ArrayList<TestSample>(this.testSamples.values());
    }

    public String toString() {
        String result = "";
        for (TestSample currenTestSample : this.testSamples.values()) {
            result = result + currenTestSample.toString() + System.getProperty("line.separator");
        }
        return result;
    }

    public Element toXMLString() {
        Element root = new Element("catalog");
        for (TestSample sample : this.testSamples.values()) {
            Element sampleRowElement = new Element("mtDNA_lines");
            Element newElement = new Element("sample_name");
            newElement.setText(sample.getSampleID().toString());
            sampleRowElement.addContent(newElement);
            newElement = new Element("range");
            SampleRanges range = sample.getSample().getSampleRanges();
            ArrayList<Integer> startRange = range.getStarts();
            ArrayList<Integer> endRange = range.getEnds();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < startRange.size(); ++i) {
                if (startRange.get(i).equals(endRange.get(i))) {
                    result.append(startRange.get(i) + "; ");
                    continue;
                }
                result.append(startRange.get(i) + "-" + endRange.get(i) + "; ");
            }
            newElement.setText(result.toString());
            sampleRowElement.addContent(newElement);
            newElement = new Element("haplogroup");
            if (sample.getExpectedHaplogroup().toString().equals("") && sample.getDetectedHaplogroup() != null) {
                sample.setExpectedHaplogroup(sample.getDetectedHaplogroup());
            }
            if (sample.isReset()) {
                newElement.setText(sample.getExpectedHaplogroup().toString());
            } else if (sample.getDetectedHaplogroup() != null && !sample.getDetectedHaplogroup().equals(sample.getExpectedHaplogroup())) {
                newElement.setText(sample.getExpectedHaplogroup().toString() + " (" + sample.getDetectedHaplogroup().toString() + ")");
            } else {
                newElement.setText(sample.getExpectedHaplogroup().toString());
            }
            sampleRowElement.addContent(newElement);
            newElement = new Element("hit");
            DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
            RankedResult topResult = sample.getTopResult();
            if (topResult != null) {
                newElement.setText(df.format(topResult.getDistance() * 100.0) + " %");
            } else {
                newElement.setText(String.valueOf(0));
            }
            sampleRowElement.addContent(newElement);
            newElement = new Element("err");
            if (this.getQualityAssistent() != null) {
                newElement.setText(String.valueOf(this.getQualityAssistent().getNumIssuedErrors(sample)));
            } else {
                newElement.setText("-");
            }
            sampleRowElement.addContent(newElement);
            newElement = new Element("war");
            if (this.getQualityAssistent() != null) {
                newElement.setText(String.valueOf(this.getQualityAssistent().getNumIssuedWarnings(sample)));
            } else {
                newElement.setText("-");
            }
            sampleRowElement.addContent(newElement);
            ArrayList<Polymorphism> t = sample.getSample().getPolymorphisms();
            String polys = "";
            for (Polymorphism t1 : t) {
                polys = polys + t1.toString() + " ";
            }
            newElement = new Element("polys");
            sampleRowElement.addContent(newElement);
            newElement.setText(polys);
            root.addContent(sampleRowElement);
        }
        return root;
    }

    public void updateClassificationResults(Phylotree phylotree, RankingMethod rankingMethod) {
        this.usedPhyloTreeLastRun = phylotree;
        this.usedRankingMethodLastRun = rankingMethod;
        long start = System.currentTimeMillis();
        for (TestSample currenTestSample : this.testSamples.values()) {
            currenTestSample.updateSearchResults(phylotree, rankingMethod);
        }
    }

    public void runQualityChecks(Phylotree phylotree) {
        if (this.qualityAssistent == null) {
            RuleSet rules = new RuleSet();
            rules.addStandardRules();
            this.qualityAssistent = new QualityAssistent(this.testSamples.values(), rules, phylotree);
        }
        this.qualityAssistent.reevaluateRules();
    }

    public void applyNomenclatureRules(Phylotree phylotree, String file) {
        if (this.qualityAssistent == null) {
            RuleSet rules = new RuleSet();
            rules.addNomenclatureRules(file);
            this.qualityAssistent = new QualityAssistent(this.testSamples.values(), rules, phylotree);
        }
        this.qualityAssistent.reevaluateRules();
    }

    public void reevaluateSample(TestSample sampleToReevaluate) {
        this.qualityAssistent.reevaluateRulesForSample(sampleToReevaluate);
        if (!this.qualityAssistent.hasFatalIssues(sampleToReevaluate)) {
            sampleToReevaluate.updateSearchResults(this.usedPhyloTreeLastRun, this.usedRankingMethodLastRun);
        }
    }

    public void clearClassificationResults() {
        for (TestSample currentSample : this.testSamples.values()) {
            currentSample.clearSearchResults();
        }
    }

    public File createOverviewImageFileBestResults(String sessionID, String format, int resolution, boolean includeHotspots, boolean includeAAC) {
        OverviewTree resultTree = this.combineAllSamplesToXMLTree(includeHotspots);
        File image = null;
        PhylotreeRenderer renderer = new PhylotreeRenderer(this.testSamples.values().iterator().next().getResult(this.testSamples.values().iterator().next().getExpectedHaplogroup()).getSearchResult().getAttachedPhyloTreeNode().getTree(), resultTree);
        URL url = this.getClass().getClassLoader().getResource("haplogrepGray.png");
        try {
            renderer.setWatermark(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        renderer.setDpi(resolution);
        image = renderer.createImage(format, "download/phylogeneticTree_" + System.currentTimeMillis() + "." + format, includeHotspots, includeAAC);
        return image;
    }

    private OverviewTree combineAllSamplesToXMLTree(boolean includeHotspots) {
        OverviewTree newOverviewTree = new OverviewTree();
        for (TestSample currentSample : this.testSamples.values()) {
            if (currentSample.searchResults.size() <= 0 || currentSample.searchResults.size() <= 0) continue;
            newOverviewTree.addNewPath(currentSample, currentSample.getResult(currentSample.getExpectedHaplogroup()).getSearchResult().getDetailedResult().getPhyloTreePath());
        }
        newOverviewTree.generateLeafNodes(includeHotspots);
        return newOverviewTree;
    }

    private void saveXMLToDisc(Document combinePathsToXMLTree) {
        try {
            Format fmt = Format.getPrettyFormat();
            XMLOutputter outp = new XMLOutputter(fmt);
            File newoutputFile = new File("testOutputXML.xml");
            outp.output(combinePathsToXMLTree, (OutputStream)new FileOutputStream(newoutputFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public QualityAssistent getQualityAssistent() {
        return this.qualityAssistent;
    }

    public void correctIssue(int issueID, int correctionMethodID) {
        QualityIssue issue = this.qualityAssistent.doCorrection(issueID, correctionMethodID);
        if (issue == null) {
            issue = this.qualityAssistent.getIssueByID(issueID);
        }
        TestSample sample = issue.getSampleOfIssue();
        this.reevaluateSample(sample);
    }

    public String toHSDFileString() {
        long start = new Date().getTime();
        StringBuffer result = new StringBuffer();
        Collection<TestSample> sampleCollection = null;
        sampleCollection = this.testSamples.values();
        result.append("SampleID\tRange\tHaplogroup\tPolymorphisms\n");
        if (sampleCollection != null) {
            for (TestSample sample : sampleCollection) {
                result.append(sample.getSampleID() + "\t");
                SampleRanges range = sample.getSample().getSampleRanges();
                ArrayList<Integer> startRange = range.getStarts();
                ArrayList<Integer> endRange = range.getEnds();
                String resultRange = "";
                for (int i = 0; i < startRange.size(); ++i) {
                    resultRange = startRange.get(i).equals(endRange.get(i)) ? resultRange + startRange.get(i) + ";" : resultRange + startRange.get(i) + "-" + endRange.get(i) + ";";
                }
                result.append(resultRange + "\t");
                result.append(sample.getExpectedHaplogroup());
                for (Polymorphism poly : sample.getSample().getPolymorphisms()) {
                    result.append("\t" + poly);
                }
                result.append("\n");
            }
        }
        return result.toString();
    }
}

