/*
 * Decompiled with CFR 0.152.
 */
package dataVisualizers;

import core.Polymorphism;
import core.TestSample;
import dataVisualizers.OverviewTreeInnerNode;
import dataVisualizers.TreeNode;
import java.util.ArrayList;
import search.SearchResultTreeNode;

public class OverviewTreeLeafNode
extends TreeNode {
    private ArrayList<Polymorphism> foundPolys = new ArrayList();
    private TestSample testSample = null;
    private ArrayList<Polymorphism> remainingPolys = new ArrayList();
    private ArrayList<Polymorphism> missingPolys = new ArrayList();

    public OverviewTreeLeafNode(TreeNode parent, TestSample sample, SearchResultTreeNode attachedPhylotreeNode) {
        parent.addChild(this);
        this.parent = parent;
        this.phylotreeNode = attachedPhylotreeNode.getPhyloTreeNode();
        this.foundPolys.addAll(attachedPhylotreeNode.getFoundPolys());
        this.testSample = sample;
    }

    public void addDistinctFoundPolys(ArrayList<Polymorphism> foundPolysToAddDistinct) {
        for (Polymorphism currentPolyToAdd : foundPolysToAddDistinct) {
            if (this.foundPolys.contains(currentPolyToAdd)) continue;
            this.foundPolys.add(currentPolyToAdd);
        }
    }

    public ArrayList<Polymorphism> getFoundPolys() {
        return this.foundPolys;
    }

    public TestSample getTestSample() {
        return this.testSample;
    }

    public void updatePolys(boolean includeHotspots) {
        ArrayList foundPolysAllSamples = new ArrayList();
        OverviewTreeInnerNode c = (OverviewTreeInnerNode)this.parent;
        for (Polymorphism currentRemaining : this.testSample.getResult(this.testSample.getExpectedHaplogroup()).getSearchResult().getDetailedResult().getRemainingPolysInSample()) {
            if (!includeHotspots && (includeHotspots || currentRemaining.isMTHotspot())) continue;
            this.remainingPolys.add(currentRemaining);
        }
        for (Polymorphism currentSamplePoly : this.testSample.getResult(this.testSample.getExpectedHaplogroup()).getSearchResult().getDetailedResult().getExpectedPolys()) {
            if (currentSamplePoly.isBackMutation() || this.testSample.getSample().getPolymorphisms().contains(currentSamplePoly)) continue;
            Polymorphism newBackmutation = new Polymorphism(currentSamplePoly);
            newBackmutation.setBackMutation(true);
            this.remainingPolys.add(newBackmutation);
        }
    }

    public ArrayList<Polymorphism> getRemainingPolys() {
        return this.remainingPolys;
    }

    public ArrayList<Polymorphism> getMissingPolys() {
        return this.missingPolys;
    }
}

