/*
 * Decompiled with CFR 0.152.
 */
package dataVisualizers;

import core.Polymorphism;
import dataVisualizers.OverviewTree;
import dataVisualizers.OverviewTreeInnerNode;
import dataVisualizers.OverviewTreeLeafNode;
import dataVisualizers.RecData;
import dataVisualizers.TreeNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import phylotree.Phylotree;

public class PhylotreeRenderer {
    private Font polymorphismFont = null;
    private Font sampleIDFont = null;
    private Font haplogroupFont = null;
    private Phylotree phyloTree = null;
    private OverviewTree xmlPhyloTree = null;
    private BufferedImage watermark = null;
    private final int linePadding = 3;
    private float dpi = 72.0f;
    private int numEndNode = 0;
    int domi = 0;

    public PhylotreeRenderer(Phylotree phyloTree, OverviewTree xmlPhyloTree) {
        this.xmlPhyloTree = xmlPhyloTree;
        this.phyloTree = phyloTree;
        this.polymorphismFont = new Font("Arial", 0, 12);
        this.sampleIDFont = new Font("Arial", 0, 16);
        this.haplogroupFont = new Font("Arial", 1, 14);
    }

    public void setWatermark(URL path) throws IOException {
        this.watermark = ImageIO.read(path);
    }

    public float getDpi() {
        return this.dpi;
    }

    public void setDpi(float dpi) {
        this.dpi = dpi;
    }

    public File createImage(String format, String path, boolean includeHotspots, boolean includeAAC) {
        File newImage = null;
        try {
            newImage = this.renderImage(format, path, includeHotspots, includeAAC);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newImage;
    }

    private File renderImage(String format, String path, boolean includeHotspots, boolean includeAAC) throws Exception {
        SVGGraphics2D svgGraphics2D;
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setEmbeddedFontsOn(true);
        SVGGraphics2D g2 = svgGraphics2D = new SVGGraphics2D(document);
        RecData r = this.traverseTree((Graphics2D)g2, this.xmlPhyloTree.getRootNode(), 0, new RecData(0, 20, 0, 0), 0, includeAAC);
        int imageWidth = r.getCurrentPos() + r.getMaxWidth() / 2;
        if (imageWidth < 300) {
            imageWidth = 300;
        }
        int treeHeight = r.getMaxHeight() + 50;
        int imageHeight = treeHeight + g2.getFontMetrics().getHeight() * 7 + 10;
        document = domImpl.createDocument(svgNS, "svg", null);
        ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setEmbeddedFontsOn(true);
        g2 = svgGraphics2D = new SVGGraphics2D(document);
        g2.setBackground(Color.white);
        svgGraphics2D.setSVGCanvasSize(new Dimension(imageWidth, imageHeight));
        g2.clearRect(0, 0, imageWidth, imageHeight);
        if (imageWidth == 300) {
            int treeWidth = r.getCurrentPos() + r.getMaxWidth() / 2;
            r = this.traverseTree((Graphics2D)g2, this.xmlPhyloTree.getRootNode(), 0, new RecData(0, 20 + treeWidth / 2, 0, 0), treeHeight, includeAAC);
        } else {
            r = this.traverseTree((Graphics2D)g2, this.xmlPhyloTree.getRootNode(), 0, new RecData(0, 20, 0, 0), treeHeight, includeAAC);
        }
        g2.setFont(this.haplogroupFont);
        int boxWidth = g2.getFontMetrics().stringWidth("@ = assumed back mutation") + 20;
        g2.drawString("KEY", 30, treeHeight + g2.getFontMetrics().getHeight());
        int boxY = treeHeight + g2.getFontMetrics().getHeight() * 2;
        if (includeHotspots) {
            g2.setColor(new Color(153, 204, 153));
            g2.drawString("Hotspot", 30, boxY);
            boxY += g2.getFontMetrics().getHeight();
        }
        g2.setColor(new Color(50, 180, 227));
        g2.drawString("Local private mutation", 30, boxY);
        g2.setColor(Color.red);
        g2.drawString("Global private mutation", 30, boxY += g2.getFontMetrics().getHeight());
        g2.setColor(Color.black);
        g2.drawString("@ = assumed back mutation", 30, boxY += g2.getFontMetrics().getHeight());
        g2.drawString("or missing mutation", 30 + g2.getFontMetrics().stringWidth("@ = "), boxY += g2.getFontMetrics().getHeight());
        g2.setColor(Color.gray);
        g2.drawString("Heteroplasmic mutation", 30, boxY += g2.getFontMetrics().getHeight());
        boxY += g2.getFontMetrics().getHeight();
        g2.setColor(new Color(0, 0, 0));
        g2.draw3DRect(20, treeHeight, boxWidth, (boxY += g2.getFontMetrics().getHeight()) + 10 - treeHeight, true);
        if (format.equals("SVG")) {
            File resultFile = new File(path);
            FileOutputStream outFile = new FileOutputStream(resultFile);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outFile, "UTF-8");
            svgGraphics2D.stream((Writer)out, true);
            return resultFile;
        }
        if (format.equals("PDF")) {
            File resultFile = new File(path);
            FileOutputStream outFile = new FileOutputStream(resultFile);
            PDFTranscoder transcoder = new PDFTranscoder();
            ByteArrayOutputStream outb = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outb, "UTF-8");
            svgGraphics2D.stream((Writer)out, true);
            TranscoderInput input = new TranscoderInput((InputStream)new ByteArrayInputStream(outb.toByteArray()));
            TranscoderOutput output = new TranscoderOutput((OutputStream)outFile);
            transcoder.addTranscodingHint(AbstractFOPTranscoder.KEY_STROKE_TEXT, (Object)new Boolean(false));
            transcoder.transcode(input, output);
            return resultFile;
        }
        return this.rescale(svgGraphics2D, r.getCurrentPos() + r.getMaxWidth() / 2, r.getMaxHeight() + g2.getFontMetrics().getHeight() * 4, path);
    }

    private File rescale(SVGGraphics2D svgGraphics2D, int widht, int height, String pathToSaveFile) {
        boolean useCSS = true;
        try {
            ByteArrayOutputStream outb = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outb, "UTF-8");
            svgGraphics2D.stream((Writer)out, useCSS);
            PNGTranscoder transcoder = new PNGTranscoder();
            TranscoderInput input = new TranscoderInput((InputStream)new ByteArrayInputStream(outb.toByteArray()));
            this.dpi = 72.0f;
            File resultFile = new File(pathToSaveFile);
            FileOutputStream outFile = new FileOutputStream(resultFile);
            TranscoderOutput output = new TranscoderOutput((OutputStream)outFile);
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)Float.valueOf(0.16933334f));
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf((float)((double)((float)widht * this.dpi) / 72.0)));
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf((float)((double)((float)height * this.dpi) / 72.0)));
            transcoder.transcode(input, output);
            return resultFile;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (SVGGraphics2DIOException e) {
            e.printStackTrace();
        }
        catch (TranscoderException e) {
            e.printStackTrace();
        }
        return null;
    }

    private RecData traverseTree(Graphics2D g2d, TreeNode result, int depth, RecData recData, int treeHeight, boolean includeAAC) throws Exception {
        int oldDepth = depth;
        g2d.setFont(this.polymorphismFont);
        ArrayList<TreeNode> list = result.getChildren();
        if (result instanceof OverviewTreeInnerNode) {
            String s = "";
            for (int i = 0; i < treeHeight; ++i) {
                s = s + " ";
            }
            int numPolys = ((OverviewTreeInnerNode)result).getExpectedPoly().size();
            int maxPolyWidth = this.getMaxStringWidthPolys(g2d, ((OverviewTreeInnerNode)result).getExpectedPoly());
            if (recData.getMaxWidth() < maxPolyWidth) {
                recData.setMaxWidth(maxPolyWidth);
            }
            depth += (1 + numPolys) * (g2d.getFontMetrics().getHeight() + 3) + 15;
            String haplogroupName = result.getPhyloTreeNode().getHaplogroup().toString();
            g2d.setFont(this.haplogroupFont);
            int maxHaplogroupWidth = g2d.getFontMetrics().stringWidth(haplogroupName) + 5;
            if (recData.getMaxWidth() < maxHaplogroupWidth) {
                recData.setMaxWidth(maxHaplogroupWidth);
            }
            g2d.setFont(this.polymorphismFont);
            RecData rNodeData = null;
            RecData lNodeData = null;
            int maxdepth = 0;
            for (int i = 0; i < list.size(); ++i) {
                if (list.size() > 1) {
                    recData.setMaxWidth(0);
                    recData = this.traverseTree(g2d, (TreeNode)list.get(i), depth, recData, treeHeight, includeAAC);
                } else {
                    recData = this.traverseTree(g2d, (TreeNode)list.get(i), depth, recData, treeHeight, includeAAC);
                }
                if (maxdepth < recData.getMaxHeight()) {
                    maxdepth = recData.getMaxHeight();
                }
                if (i == 0) {
                    lNodeData = recData;
                }
                if (i != list.size() - 1) continue;
                rNodeData = recData;
            }
            int superNodePosXCentered = lNodeData.getCenter() + (rNodeData.getCenter() - lNodeData.getCenter()) / 2;
            g2d.drawLine(lNodeData.getCenter(), depth, rNodeData.getCenter(), depth);
            g2d.drawLine(superNodePosXCentered, oldDepth + 10, superNodePosXCentered, oldDepth);
            this.drawPolymorhismn(g2d, (OverviewTreeInnerNode)result, superNodePosXCentered, depth);
            this.drawHaplogroupNode(g2d, superNodePosXCentered, depth += 5, haplogroupName);
            return new RecData(superNodePosXCentered, recData.getCurrentPos(), recData.getMaxWidth(), maxdepth);
        }
        int widthHgLabel = g2d.getFontMetrics().getHeight();
        int maxUnused = this.getMaxStringWidthUnusedPolys(g2d, (OverviewTreeLeafNode)result);
        if (recData.getMaxWidth() < maxUnused) {
            recData.setMaxWidth(maxUnused);
        }
        int delta = recData.getMaxWidth();
        int left = recData.getCurrentPos();
        int right = 0;
        right = delta < widthHgLabel ? recData.getCurrentPos() + widthHgLabel + 10 : recData.getCurrentPos() + delta + 5;
        int center = left + (right - left) / 2;
        RecData newData = new RecData(center, right, recData.getMaxWidth(), depth);
        g2d.setColor(Color.black);
        g2d.drawLine(newData.getCenter(), oldDepth, newData.getCenter(), oldDepth + 10);
        int y = this.drawEndNode(g2d, (OverviewTreeLeafNode)result, newData.getCenter(), depth, treeHeight, includeAAC);
        newData.setMaxHeight(y);
        return newData;
    }

    private int getMaxStringWidthPolys(Graphics2D g2d, List<Polymorphism> polys) {
        int max = 0;
        int width = 0;
        for (Polymorphism currentPoly : polys) {
            width = g2d.getFontMetrics().stringWidth(currentPoly.toString());
            if (max >= width) continue;
            max = width;
        }
        return width;
    }

    private int getMaxStringWidthUnusedPolys(Graphics2D g2d, OverviewTreeLeafNode tree) {
        int max = 0;
        int width = 0;
        g2d.setFont(this.polymorphismFont);
        for (Polymorphism currentPoly : tree.getRemainingPolys()) {
            width = g2d.getFontMetrics().stringWidth(currentPoly.toString() + "mis");
            if (max >= width) continue;
            max = width;
        }
        return max;
    }

    private int drawEndNode(Graphics2D g2d, OverviewTreeLeafNode leafNode, int center, int depth, int treeHeight, boolean includeAAC) {
        g2d.setFont(this.polymorphismFont);
        depth += 10;
        Collections.sort(leafNode.getRemainingPolys());
        for (Polymorphism currentPoly : leafNode.getRemainingPolys()) {
            depth += g2d.getFontMetrics().getHeight() + 3;
            if (currentPoly.isMTHotspot()) {
                g2d.setColor(new Color(153, 204, 153));
            } else if (currentPoly.isBackMutation()) {
                g2d.setColor(Color.black);
            } else if (currentPoly.isHeteroplasmy()) {
                g2d.setColor(Color.gray);
            } else if (this.phyloTree.getMutationRate(currentPoly) == 0.0) {
                g2d.setColor(Color.red);
            } else {
                g2d.setColor(new Color(50, 180, 227));
            }
            if (includeAAC) {
                try {
                    if (currentPoly.getAnnotation() != null) {
                        this.drawCenteredNode(g2d, center, depth, Polymorphism.convertToATBackmutation(currentPoly.toStringShortVersion()) + " " + currentPoly.getAnnotation().getAminoAcidChange());
                        continue;
                    }
                    this.drawCenteredNode(g2d, center, depth, Polymorphism.convertToATBackmutation(currentPoly.toStringShortVersion()));
                }
                catch (Exception exception) {}
                continue;
            }
            this.drawCenteredNode(g2d, center, depth, Polymorphism.convertToATBackmutation(currentPoly.toStringShortVersion()));
        }
        g2d.setColor(Color.black);
        g2d.drawLine(center, depth, center, treeHeight - 15);
        this.drawSampleIDNode(g2d, leafNode.getTestSample().getSampleID(), center, treeHeight);
        g2d.setFont(this.sampleIDFont);
        return depth + g2d.getFontMetrics().stringWidth(leafNode.getTestSample().getSampleID()) + 20;
    }

    private void drawHaplogroupNode(Graphics2D g2d, int x, int y, String haplogroupName) {
        g2d.setFont(this.haplogroupFont);
        g2d.setColor(Color.black);
        this.drawCenteredNode(g2d, x, y - 2, haplogroupName);
        int width = Math.max(g2d.getFontMetrics().stringWidth(haplogroupName), 20);
        g2d.drawRect(x - width / 2 - 4, y - g2d.getFontMetrics().getHeight() - 7, width + 8, g2d.getFontMetrics().getHeight());
    }

    private void drawPolymorhismn(Graphics2D g2d, OverviewTreeInnerNode currentNode, int x, int y) {
        g2d.setFont(this.polymorphismFont);
        g2d.setColor(Color.black);
        y -= 5 + currentNode.getExpectedPoly().size() * (g2d.getFontMetrics().getHeight() + 3);
        Collections.sort(currentNode.getExpectedPoly());
        for (Polymorphism currentPoly : currentNode.getExpectedPoly()) {
            this.drawCenteredNode(g2d, x, y, Polymorphism.convertToATBackmutation(currentPoly.toStringShortVersion()));
            y += g2d.getFontMetrics().getHeight() + 3;
        }
    }

    private void drawSampleIDNode(Graphics2D g2d, String sampleIDText, int x, int y) {
        g2d.setFont(this.sampleIDFont);
        g2d.setColor(Color.black);
        int widthSampleID = g2d.getFontMetrics().stringWidth(sampleIDText);
        g2d.drawLine(x, y -= widthSampleID + 15, x, y + 4);
        g2d.translate(x - 6, y + 5);
        g2d.rotate(Math.toRadians(90.0));
        g2d.clearRect(-5, -15, widthSampleID + 5, 19);
        int[] polylineX = new int[]{-6, 0, 6 + widthSampleID - 6, 12 + widthSampleID - 6, 6 + widthSampleID - 6, 0, -6};
        int[] polylineY = new int[]{-g2d.getFontMetrics().getHeight() / 2 + 2, 6, 6, -g2d.getFontMetrics().getHeight() / 2 + 2, -g2d.getFontMetrics().getHeight(), -g2d.getFontMetrics().getHeight(), -g2d.getFontMetrics().getHeight() / 2 + 2};
        g2d.drawPolyline(polylineX, polylineY, 7);
        g2d.drawString(sampleIDText, 2, 0);
        g2d.rotate(Math.toRadians(-90.0));
        g2d.translate(-(x - 6), -(y + 5));
    }

    private void drawCenteredNode(Graphics2D g2d, int x, int y, String text) {
        int stringWidth = g2d.getFontMetrics().stringWidth(text);
        g2d.drawString(text, x - stringWidth / 2, y - g2d.getFontMetrics().getHeight() / 2);
    }
}

