/*
 * Decompiled with CFR 0.152.
 */
package genepi;

import genepi.commands.DistanceCheckCommand;
import genepi.commands.HaplogrepCommand;
import java.util.Arrays;
import picocli.CommandLine;

@CommandLine.Command(name="haplogrep")
public class App
implements Runnable {
    public static final String URL = "https://github.com/seppinho/haplogrep-cmd";
    public static final String APP = "mtDNA Haplogroup Classifiction";
    public static final String VERSION = "v2.4.0";
    public static final String COPYRIGHT = "(c) Sebastian Sch\u00f6nherr, Hansi Weissensteiner, Lukas Forer, Dominic Pacher";
    public static final String CONTACT = "sebastian.schoenherr@i-med.ac.at";
    public static String COMMAND;
    static CommandLine commandLine;
    @CommandLine.Option(names={"--version"}, versionHelp=true)
    boolean showVersion;

    public static void main(String[] args) {
        System.out.println();
        System.out.println("mtDNA Haplogroup Classifiction v2.4.0");
        if (URL != null && !URL.isEmpty()) {
            System.out.println(URL);
        }
        if (COPYRIGHT != null && !COPYRIGHT.isEmpty()) {
            System.out.println(COPYRIGHT);
        }
        if (CONTACT != null && !CONTACT.isEmpty()) {
            System.out.println(CONTACT);
            System.out.println();
        }
        COMMAND = Arrays.toString(args);
        System.out.println(COMMAND);
        commandLine = new CommandLine(new App());
        commandLine.addSubcommand("classify", new HaplogrepCommand());
        commandLine.addSubcommand("distance", new DistanceCheckCommand());
        commandLine.setExecutionStrategy(new CommandLine.RunLast());
        commandLine.execute(args);
    }

    @Override
    public void run() {
        System.out.println("haplogrep");
        commandLine.usage(System.out);
    }
}

