/*
 * Decompiled with CFR 0.152.
 */
package genepi.base;

import genepi.base.Tool;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class Toolbox {
    private Map<String, Class> tools = new HashMap<String, Class>();
    private String command;
    private String[] args;

    public Toolbox(String command, String[] args) {
        this.args = args;
        this.command = command;
    }

    public void addTool(String command, Class clazz) {
        this.tools.put(command, clazz);
    }

    public void start() throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        if (this.args.length > 0) {
            String tool = this.args[0];
            String[] newargs = new String[this.args.length - 1];
            for (int i = 0; i < newargs.length; ++i) {
                newargs[i] = this.args[i + 1];
            }
            Class clazz = this.tools.get(tool);
            if (clazz != null) {
                Constructor constructor = clazz.getConstructor(String[].class);
                Tool instance = (Tool)constructor.newInstance(new Object[]{newargs});
                int status = instance.start();
                System.exit(status);
            } else {
                System.out.println("\nUnknown tool: " + tool);
                this.help();
                System.exit(1);
            }
        } else {
            this.help();
            System.exit(1);
        }
    }

    protected void help() {
        System.out.println("\nusage: " + this.command + " <tool> <params>\n");
        System.out.println("Available Tools:");
        for (String t : this.tools.keySet()) {
            System.out.println("  " + t);
        }
        System.out.println("");
    }
}

