/*
 * Decompiled with CFR 0.152.
 */
package genepi.commands;

import core.SampleFile;
import core.TestSample;
import genepi.haplogrep.util.HgClassifier;
import importer.FastaImporter;
import importer.HsdImporter;
import importer.VcfImporter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import util.ExportUtils;
import vcf.Sample;

public class HaplogrepCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--in", "--input"}, description={"Input VCF, fasta or hsd file"}, required=true)
    String in;
    @CommandLine.Option(names={"--out", "--output"}, description={"Output file location"}, required=true)
    String out;
    @CommandLine.Option(names={"--format"}, description={"Specify input file format: vcf, fasta or hsd"}, required=true)
    String format;
    @CommandLine.Option(names={"--phylotree"}, description={"Specify phylotree version"}, required=false)
    String tree;
    @CommandLine.Option(names={"--rsrs"}, description={"Use RSRS Version"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean rsrs = false;
    @CommandLine.Option(names={"--skip-alignment-rules"}, description={"Skip mtDNA nomenclature fixes based on rules for FASTA import"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean skipRules = false;
    @CommandLine.Option(names={"--extend-report"}, description={"Add flag for a extended final output"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean extendedReport = false;
    @CommandLine.Option(names={"--write-fasta"}, description={"Write results in fasta format"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean writeFasta = false;
    @CommandLine.Option(names={"--write-fasta-msa"}, description={"Write multiple sequence alignment (_MSA.fasta) "}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean writeFastaMSA = false;
    @CommandLine.Option(names={"--chip"}, description={"VCF data from a genotype chip"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean chip = false;
    @CommandLine.Option(names={"--metric"}, description={"Specifiy other metrics (hamming or jaccard) than default (kulczynski)"}, required=false)
    String metric;
    @CommandLine.Option(names={"--lineage"}, description={"Export lineage information as dot file, \\n0=no tree, 1=with SNPs, 2=only structure, no SNPs"}, required=false)
    String lineage;
    @CommandLine.Option(names={"--hits"}, description={"Calculate best n hits"}, required=false)
    String hits;
    @CommandLine.Option(names={"--hetLevel"}, description={"Add heteroplasmies with a level > X from the VCF file to the profile (default: 0.9)"}, required=false)
    String hetLevel;

    @Override
    public Integer call() {
        long start;
        block20: {
            File input;
            if (this.chip && !this.format.toLowerCase().equals("vcf")) {
                System.out.println("The --chip flag only works for files in VCF format. For hsd, please specify the included variants in the Haplogrep range.");
                return -1;
            }
            if (this.metric == null) {
                this.metric = "kulczynski";
            }
            if (this.tree == null) {
                this.tree = "17_FU1";
            }
            if (this.hits == null) {
                this.hits = "1";
            }
            if (this.hetLevel == null) {
                this.hetLevel = "0.9";
            }
            if (this.lineage == null) {
                this.lineage = "0";
            }
            if (!(input = new File(this.in)).exists()) {
                System.out.println("Error. Please check if input file exists");
                return -1;
            }
            String phylotree = "phylotree$VERSION$RSRS.xml";
            String fluctrates = "weights$VERSION$RSRS.txt";
            phylotree = phylotree.replace("$VERSION", this.tree);
            fluctrates = fluctrates.replace("$VERSION", this.tree);
            if (this.rsrs) {
                phylotree = phylotree.replace("$RSRS", "_rsrs");
                fluctrates = fluctrates.replace("$RSRS", "_rsrs");
            } else {
                phylotree = phylotree.replace("$RSRS", "");
                fluctrates = fluctrates.replace("$RSRS", "");
            }
            System.out.println(phylotree);
            System.out.println("Parameters:");
            System.out.println("Input format: " + this.format);
            System.out.println("Phylotree version: " + this.tree);
            System.out.println("Reference: " + (this.rsrs ? "RSRS" : "rCRS"));
            System.out.println("Extended report: " + this.extendedReport);
            System.out.println("Skip alignment rules: " + this.skipRules);
            System.out.println("Used metric: " + this.metric);
            System.out.println("Chip array data: " + this.chip);
            System.out.println("Lineage: " + this.lineage);
            System.out.println("");
            start = System.currentTimeMillis();
            System.out.println("Start Classification...");
            try {
                if (input.isFile()) {
                    Object importer;
                    ArrayList<String> lines = new ArrayList();
                    if (this.format.equals("hsd")) {
                        importer = new HsdImporter();
                        lines = ((HsdImporter)importer).load(input);
                    } else if (this.format.equals("vcf")) {
                        VcfImporter importerVcf = new VcfImporter();
                        HashMap<String, Sample> samples = importerVcf.load(input, this.chip);
                        lines = ExportUtils.vcfTohsd(samples, Double.valueOf(this.hetLevel));
                    } else if (this.format.equals("fasta")) {
                        importer = new FastaImporter();
                        lines = this.rsrs ? ((FastaImporter)importer).load(input, FastaImporter.References.RSRS) : ((FastaImporter)importer).load(input, FastaImporter.References.RCRS);
                    }
                    if (lines != null) {
                        SampleFile newSampleFile = new SampleFile(lines);
                        HgClassifier classifier = new HgClassifier();
                        classifier.run(newSampleFile, phylotree, fluctrates, this.metric, Integer.valueOf(this.hits), this.skipRules, this.format);
                        ArrayList<TestSample> samples = newSampleFile.getTestSamples();
                        ExportUtils.createReport(samples, this.out, this.extendedReport);
                        ExportUtils.calcLineage(samples, Integer.valueOf(this.lineage), this.out);
                        if (this.writeFasta) {
                            ExportUtils.generateFasta(samples, this.out);
                        }
                        if (this.writeFastaMSA) {
                            ExportUtils.generateFastaMSA(samples, this.out);
                        }
                    }
                    break block20;
                }
                return -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        System.out.println("HaploGrep file written to " + new File(this.out).getAbsolutePath() + " (Time: " + (System.currentTimeMillis() - start) / 1000L + " sec)");
        return 0;
    }
}

