/*
 * Decompiled with CFR 0.152.
 */
package genepi.io;

import genepi.io.WildCardFileFilter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;

public class FileUtil {
    public static boolean deleteFile(String filename) {
        return new File(filename).delete();
    }

    public static String[] getFiles(String path, String ext) {
        File dir = new File(path);
        File[] files = dir.listFiles(new WildCardFileFilter(ext));
        String[] names = new String[files.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = files[i].getAbsolutePath();
        }
        return names;
    }

    public static boolean createDirectory(String dir) {
        File output = new File(dir);
        if (!output.exists()) {
            return output.mkdirs();
        }
        return true;
    }

    public static boolean copyDirectory(String source, String target) {
        String[] files;
        for (String sourceFile : files = FileUtil.getFiles(source, "*.*")) {
            String name = new File(sourceFile).getName();
            String targetFile = FileUtil.path(target, name);
            FileUtil.copy(sourceFile, targetFile);
        }
        return true;
    }

    public static boolean deleteDirectory(String path) {
        return FileUtil.deleteDirectory(new File(path));
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtil.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static boolean copy(String source, String target) {
        try {
            FileInputStream fin = new FileInputStream(source);
            FileOutputStream fout = new FileOutputStream(target);
            byte[] b = new byte[1024];
            int noOfBytes = 0;
            while ((noOfBytes = fin.read(b)) != -1) {
                fout.write(b, 0, noOfBytes);
            }
            fin.close();
            fout.close();
        }
        catch (FileNotFoundException fnf) {
            System.out.println("Specified file not found :" + fnf);
        }
        catch (IOException ioe) {
            System.out.println("Error while copying file :" + ioe);
        }
        return true;
    }

    public static boolean copy2(String source, String target) {
        try {
            int c;
            File inputFile = new File(source);
            File outputFile = new File(target);
            FileReader in = new FileReader(inputFile);
            FileWriter out = new FileWriter(outputFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String path(String ... paths) {
        String result = "";
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (path == null || path.isEmpty()) continue;
            if (i > 0 && !path.startsWith(File.separator) && !result.endsWith(File.separator)) {
                if (result.isEmpty()) {
                    result = result + path;
                    continue;
                }
                result = result + File.separator + path;
                continue;
            }
            result = result + path;
        }
        return result;
    }

    public static String getFilename(String filename) {
        return new File(filename).getName();
    }

    public static void writeStringBufferToFile(String filename, StringBuffer buffer) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            String outText = buffer.toString();
            out.write(outText);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readFileAsString(String filePath) {
        try {
            StringBuffer fileData = new StringBuffer(1000);
            BufferedReader reader = new BufferedReader(new FileReader(filePath));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
            return fileData.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String readFileAsString(InputStream in) {
        try {
            StringBuffer fileData = new StringBuffer(1000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
            return fileData.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLineCount(String filename) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));){
            byte[] c = new byte[1024];
            int count = 0;
            int readChars = 0;
            boolean empty = true;
            while ((readChars = ((InputStream)is).read(c)) != -1) {
                empty = false;
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
            }
            int n = count == 0 && !empty ? 1 : count;
            return n;
        }
    }

    public static InputStream decompressStream(InputStream input) throws IOException {
        PushbackInputStream pb = new PushbackInputStream(input, 2);
        byte[] signature = new byte[2];
        pb.read(signature);
        pb.unread(signature);
        if (signature[0] == 31 && signature[1] == -117) {
            return new GZIPInputStream(pb);
        }
        return pb;
    }
}

