/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.mach;

import java.io.IOException;

public class MachHap {
    private String sample;
    private int[] haps;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MachHap(String line) throws IOException {
        String[] tiles = line.split("\\s+");
        if (tiles.length != 3) throw new IOException("Parsing error.");
        this.sample = tiles[0];
        String type = tiles[1];
        if (!type.equals("HAPLO") && !type.equals("HAPLO1") && !type.equals("HAPLO2")) throw new IOException("Parsing error.");
        this.haps = new int[tiles[2].length()];
        for (int i = 0; i < tiles[2].length(); ++i) {
            this.haps[i] = Integer.parseInt(tiles[2].charAt(i) + "");
        }
    }

    public MachHap(String sample, int[] haps) {
        this.sample = sample;
        this.haps = haps;
    }

    public String getSample() {
        return this.sample;
    }

    public void setSample(String sample) {
        this.sample = sample;
    }

    public int[] getHaps() {
        return this.haps;
    }

    public void setHaps(int[] haps) {
        this.haps = haps;
    }

    public int getNumberHaps() {
        return this.haps.length;
    }

    public String toString() {
        return this.sample + " (" + this.getNumberHaps() + " haps)";
    }
}

