/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.shapeit;

import genepi.io.shapeit.Chromosome;
import java.io.IOException;

public class ShapeitHap {
    private String chromosome;
    private String snp;
    private long position;
    private String firstAllele;
    private String secondAllele;
    private int[] haps;

    public ShapeitHap(String line, String chr) throws IOException {
        String[] tiles = line.split("\\s{1}(?!\\s)");
        if (tiles.length > 5) {
            this.chromosome = tiles[0].trim();
            if (!Chromosome.isValid(this.chromosome)) {
                if (chr != null) {
                    this.chromosome = chr;
                } else {
                    throw new IOException("Invalid Chromosome " + this.chromosome + ".");
                }
            }
            this.snp = tiles[1].trim();
            this.position = Long.parseLong(tiles[2].trim());
            this.firstAllele = tiles[3].trim();
            this.secondAllele = tiles[4].trim();
            this.haps = new int[tiles.length - 5];
            for (int i = 0; i < this.haps.length; ++i) {
                this.haps[i] = Integer.parseInt(tiles[i + 5].trim());
                if (this.haps[i] == 0 || this.haps[i] == 1) continue;
                throw new IOException("Haplotypes for snp " + this.snp + " have invalid syntax.");
            }
        } else {
            throw new IOException("Expected: 5 columns. Found: " + tiles.length + " columns.");
        }
    }

    public int[] getHaps() {
        return this.haps;
    }

    public void setHaps(int[] haps) {
        this.haps = haps;
    }

    public int getNumberHaps() {
        return this.haps.length;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public String getFirstAllele() {
        return this.firstAllele;
    }

    public void setFirstAllele(String firstAllele) {
        this.firstAllele = firstAllele;
    }

    public String getSecondAllele() {
        return this.secondAllele;
    }

    public void setSecondAllele(String secondAllele) {
        this.secondAllele = secondAllele;
    }

    public String getSnp() {
        return this.snp;
    }

    public void setSnp(String snp) {
        this.snp = snp;
    }

    public String toString() {
        return this.snp + " (" + this.getNumberHaps() + " haps)";
    }
}

