/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.shapeit;

import genepi.io.FileUtil;
import genepi.io.shapeit.ShapeitHap;
import genepi.io.text.AbstractLineReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;

public class ShapeitHapsReader
extends AbstractLineReader<ShapeitHap> {
    private ShapeitHap currentHap;

    public ShapeitHapsReader(String filename) throws IOException {
        super(filename);
    }

    public ShapeitHapsReader(DataInputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    protected void parseLine(String line) throws Exception {
        String[] tiles;
        String chr = null;
        for (String tile : tiles = FileUtil.getFilename(this.getFilename()).split("\\.")) {
            if (!tile.toLowerCase().startsWith("chr")) continue;
            chr = tile.replaceAll("chr", "");
        }
        this.currentHap = new ShapeitHap(line, chr);
    }

    @Override
    public ShapeitHap get() {
        return this.currentHap;
    }

    @Override
    public Iterator<ShapeitHap> iterator() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public static void main(String[] args) {
        String[] tiles;
        String filename = "metsim.gwas.b37.chr15.sample";
        String chr = null;
        for (String tile : tiles = FileUtil.getFilename(filename).split("\\.")) {
            if (!tile.toLowerCase().startsWith("chr")) continue;
            chr = tile.replaceAll("chr", "");
        }
        System.out.println(chr);
    }
}

